/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import junit.framework.TestCase;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

public class WKBWriterTest
extends TestCase {
    public WKBWriterTest(String name) {
        super(name);
    }

    public void testSRID() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Point p1 = gf.createPoint(new Coordinate(1.0, 2.0));
        p1.setSRID(1234);
        WKBWriter w = new WKBWriter();
        byte[] wkb = w.write((Geometry)p1);
        byte b = (byte)(wkb[1] & 0x20);
        WKBWriterTest.assertEquals((int)0, (int)b);
        WKBReader r = new WKBReader(gf);
        Point p2 = (Point)r.read(wkb);
        WKBWriterTest.assertTrue((boolean)p1.equalsExact((Geometry)p2));
        WKBWriterTest.assertEquals((int)0, (int)p2.getSRID());
        w = new WKBWriter(2, true);
        wkb = w.write((Geometry)p1);
        b = (byte)(wkb[1] & 0x20);
        WKBWriterTest.assertEquals((int)32, (int)b);
        int srid = (wkb[5] & 0xFF) << 24 | (wkb[6] & 0xFF) << 16 | (wkb[7] & 0xFF) << 8 | wkb[8] & 0xFF;
        WKBWriterTest.assertEquals((int)1234, (int)srid);
        r = new WKBReader(gf);
        p2 = (Point)r.read(wkb);
        WKBWriterTest.assertTrue((boolean)p1.equalsExact((Geometry)p2));
        WKBWriterTest.assertEquals((int)1234, (int)p2.getSRID());
    }
}

