/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.IOException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class WKTReaderExpTest
extends TestCase {
    private GeometryFactory fact = new GeometryFactory();
    private WKTReader rdr = new WKTReader(this.fact);

    public static void main(String[] args) {
        TestRunner.run(WKTReaderExpTest.class);
    }

    public WKTReaderExpTest(String name) {
        super(name);
    }

    public void testGoodBasicExp() throws IOException, ParseException {
        this.readGoodCheckCoordinate("POINT ( 1e01 -1E02)", 10.0, -100.0);
    }

    public void testGoodWithExpSign() throws IOException, ParseException {
        this.readGoodCheckCoordinate("POINT ( 1e-04 1E-05)", 1.0E-4, 1.0E-5);
    }

    public void testBadExpFormat() throws IOException, ParseException {
        this.readBad("POINT (1e0a1 1X02)");
    }

    public void testBadExpPlusSign() throws IOException, ParseException {
        this.readBad("POINT (1e+01 1X02)");
    }

    public void testBadPlusSign() throws IOException, ParseException {
        this.readBad("POINT ( +1e+01 1X02)");
    }

    private void readGoodCheckCoordinate(String wkt, double x, double y) throws IOException, ParseException {
        Geometry g = this.rdr.read(wkt);
        Coordinate pt = g.getCoordinate();
        WKTReaderExpTest.assertEquals((double)pt.x, (double)x, (double)1.0E-4);
        WKTReaderExpTest.assertEquals((double)pt.y, (double)y, (double)1.0E-4);
    }

    private void readBad(String wkt) throws IOException {
        boolean threwParseEx = false;
        try {
            Geometry geometry = this.rdr.read(wkt);
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
            threwParseEx = true;
        }
        WKTReaderExpTest.assertTrue((boolean)threwParseEx);
    }
}

