/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.IOException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class WKTReaderParseErrorTest
extends TestCase {
    private GeometryFactory fact = new GeometryFactory();
    private WKTReader rdr = new WKTReader(this.fact);

    public static void main(String[] args) {
        TestRunner.run(WKTReaderParseErrorTest.class);
    }

    public WKTReaderParseErrorTest(String name) {
        super(name);
    }

    public void testExtraLParen() throws IOException, ParseException {
        this.readBad("POINT (( 1e01 -1E02)");
    }

    public void testMissingOrdinate() throws IOException, ParseException {
        this.readBad("POINT ( 1e01 )");
    }

    public void testBadChar() throws IOException, ParseException {
        this.readBad("POINT ( # 1e-04 1E-05)");
    }

    public void testBadExpFormat() throws IOException, ParseException {
        this.readBad("POINT (1e0a1 1X02)");
    }

    public void testBadExpPlusSign() throws IOException, ParseException {
        this.readBad("POINT (1e+01 1X02)");
    }

    public void testBadPlusSign() throws IOException, ParseException {
        this.readBad("POINT ( +1e+01 1X02)");
    }

    private void readBad(String wkt) throws IOException {
        boolean threwParseEx = false;
        try {
            Geometry geometry = this.rdr.read(wkt);
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
            threwParseEx = true;
        }
        WKTReaderParseErrorTest.assertTrue((boolean)threwParseEx);
    }
}

