/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class WKTReaderTest
extends TestCase {
    WKTWriter writer = new WKTWriter();
    PrecisionModel precisionModel = new PrecisionModel(1.0);
    GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        TestRunner.run((Test)WKTReaderTest.suite());
    }

    public WKTReaderTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(WKTReaderTest.class);
    }

    public void testReadNaN() throws Exception {
        WKTReaderTest.assertEquals((Object)"POINT (10 10)", (Object)this.writer.write(this.reader.read("POINT (10 10 NaN)")));
        WKTReaderTest.assertEquals((Object)"POINT (10 10)", (Object)this.writer.write(this.reader.read("POINT (10 10 nan)")));
        WKTReaderTest.assertEquals((Object)"POINT (10 10)", (Object)this.writer.write(this.reader.read("POINT (10 10 NAN)")));
    }

    public void testReadPoint() throws Exception {
        WKTReaderTest.assertEquals((Object)"POINT (10 10)", (Object)this.writer.write(this.reader.read("POINT (10 10)")));
        WKTReaderTest.assertEquals((Object)"POINT EMPTY", (Object)this.writer.write(this.reader.read("POINT EMPTY")));
    }

    public void testReadLineString() throws Exception {
        WKTReaderTest.assertEquals((Object)"LINESTRING (10 10, 20 20, 30 40)", (Object)this.writer.write(this.reader.read("LINESTRING (10 10, 20 20, 30 40)")));
        WKTReaderTest.assertEquals((Object)"LINESTRING EMPTY", (Object)this.writer.write(this.reader.read("LINESTRING EMPTY")));
    }

    public void testReadLinearRing() throws Exception {
        try {
            this.reader.read("LINEARRING (10 10, 20 20, 30 40, 10 99)");
        }
        catch (IllegalArgumentException e) {
            WKTReaderTest.assertTrue((e.getMessage().indexOf("not form a closed linestring") > -1 ? 1 : 0) != 0);
        }
        WKTReaderTest.assertEquals((Object)"LINEARRING (10 10, 20 20, 30 40, 10 10)", (Object)this.writer.write(this.reader.read("LINEARRING (10 10, 20 20, 30 40, 10 10)")));
        WKTReaderTest.assertEquals((Object)"LINEARRING EMPTY", (Object)this.writer.write(this.reader.read("LINEARRING EMPTY")));
    }

    public void testReadPolygon() throws Exception {
        WKTReaderTest.assertEquals((Object)"POLYGON ((10 10, 10 20, 20 20, 20 15, 10 10))", (Object)this.writer.write(this.reader.read("POLYGON ((10 10, 10 20, 20 20, 20 15, 10 10))")));
        WKTReaderTest.assertEquals((Object)"POLYGON EMPTY", (Object)this.writer.write(this.reader.read("POLYGON EMPTY")));
    }

    public void testReadMultiPoint() throws Exception {
        WKTReaderTest.assertEquals((Object)"MULTIPOINT ((10 10), (20 20))", (Object)this.writer.write(this.reader.read("MULTIPOINT ((10 10), (20 20))")));
        WKTReaderTest.assertEquals((Object)"MULTIPOINT EMPTY", (Object)this.writer.write(this.reader.read("MULTIPOINT EMPTY")));
    }

    public void testReadMultiLineString() throws Exception {
        WKTReaderTest.assertEquals((Object)"MULTILINESTRING ((10 10, 20 20), (15 15, 30 15))", (Object)this.writer.write(this.reader.read("MULTILINESTRING ((10 10, 20 20), (15 15, 30 15))")));
        WKTReaderTest.assertEquals((Object)"MULTILINESTRING EMPTY", (Object)this.writer.write(this.reader.read("MULTILINESTRING EMPTY")));
    }

    public void testReadMultiPolygon() throws Exception {
        WKTReaderTest.assertEquals((Object)"MULTIPOLYGON (((10 10, 10 20, 20 20, 20 15, 10 10)), ((60 60, 70 70, 80 60, 60 60)))", (Object)this.writer.write(this.reader.read("MULTIPOLYGON (((10 10, 10 20, 20 20, 20 15, 10 10)), ((60 60, 70 70, 80 60, 60 60)))")));
        WKTReaderTest.assertEquals((Object)"MULTIPOLYGON EMPTY", (Object)this.writer.write(this.reader.read("MULTIPOLYGON EMPTY")));
    }

    public void testReadGeometryCollection() throws Exception {
        WKTReaderTest.assertEquals((Object)"GEOMETRYCOLLECTION (POINT (10 10), POINT (30 30), LINESTRING (15 15, 20 20))", (Object)this.writer.write(this.reader.read("GEOMETRYCOLLECTION (POINT (10 10), POINT (30 30), LINESTRING (15 15, 20 20))")));
        WKTReaderTest.assertEquals((Object)"GEOMETRYCOLLECTION (POINT (10 10), LINEARRING EMPTY, LINESTRING (15 15, 20 20))", (Object)this.writer.write(this.reader.read("GEOMETRYCOLLECTION (POINT (10 10), LINEARRING EMPTY, LINESTRING (15 15, 20 20))")));
        WKTReaderTest.assertEquals((Object)"GEOMETRYCOLLECTION (POINT (10 10), LINEARRING (10 10, 20 20, 30 40, 10 10), LINESTRING (15 15, 20 20))", (Object)this.writer.write(this.reader.read("GEOMETRYCOLLECTION (POINT (10 10), LINEARRING (10 10, 20 20, 30 40, 10 10), LINESTRING (15 15, 20 20))")));
        WKTReaderTest.assertEquals((Object)"GEOMETRYCOLLECTION EMPTY", (Object)this.writer.write(this.reader.read("GEOMETRYCOLLECTION EMPTY")));
    }

    public void testReadPointZM() throws Exception {
        WKTReaderTest.assertEquals((Object)new Coordinate(1.0, 2.0, 3.0), (Object)this.reader.read("POINT(1 2 3)").getCoordinate());
        WKTReaderTest.assertEquals((Object)new Coordinate(1.0, 2.0, 3.0), (Object)this.reader.read("POINTZ(1 2 3)").getCoordinate());
        WKTReaderTest.assertEquals((Object)new Coordinate(1.0, 2.0, 3.0), (Object)this.reader.read("POINT Z(1 2 3)").getCoordinate());
        WKTReaderTest.assertEquals((Object)new Coordinate(1.0, 2.0, 3.0), (Object)this.reader.read("POINTM(1 2 3)").getCoordinate());
        WKTReaderTest.assertEquals((Object)new Coordinate(1.0, 2.0, 3.0), (Object)this.reader.read("POINT M(1 2 3)").getCoordinate());
        WKTReaderTest.assertEquals((Object)new Coordinate(1.0, 2.0, 3.0), (Object)this.reader.read("POINTZM(1 2 3 4)").getCoordinate());
        WKTReaderTest.assertEquals((Object)new Coordinate(1.0, 2.0, 3.0), (Object)this.reader.read("POINT ZM(1 2 3 4)").getCoordinate());
        WKTReaderTest.assertEquals((Object)new Coordinate(1.0, 2.0, 3.0), (Object)this.reader.read("Point Zm(1 2 3 4)").getCoordinate());
    }

    public void testReadLineStringZM() throws Exception {
        WKTReaderTest.assertEquals((Object)new Coordinate(4.0, 5.0, 6.0), (Object)this.reader.read("LINESTRING(1 2 3, 4 5 6)").getCoordinates()[1]);
        WKTReaderTest.assertEquals((Object)new Coordinate(4.0, 5.0, 6.0), (Object)this.reader.read("LINESTRINGZ(1 2 3, 4 5 6)").getCoordinates()[1]);
        WKTReaderTest.assertEquals((Object)new Coordinate(4.0, 5.0, 6.0), (Object)this.reader.read("LINESTRING Z(1 2 3, 4 5 6)").getCoordinates()[1]);
        WKTReaderTest.assertEquals((Object)new Coordinate(4.0, 5.0, 6.0), (Object)this.reader.read("LINESTRINGM(1 2 3, 4 5 6)").getCoordinates()[1]);
        WKTReaderTest.assertEquals((Object)new Coordinate(4.0, 5.0, 6.0), (Object)this.reader.read("LINESTRING M(1 2 3, 4 5 6)").getCoordinates()[1]);
        WKTReaderTest.assertEquals((Object)new Coordinate(4.0, 5.0, 6.0), (Object)this.reader.read("LINESTRINGZM(1 2 3 10, 4 5 6 10)").getCoordinates()[1]);
        WKTReaderTest.assertEquals((Object)new Coordinate(4.0, 5.0, 6.0), (Object)this.reader.read("LINESTRING ZM(1 2 3 10, 4 5 6 10)").getCoordinates()[1]);
        WKTReaderTest.assertEquals((Object)new Coordinate(4.0, 5.0, 6.0), (Object)this.reader.read("LineString Zm(1 2 3 10, 4 5 6 10)").getCoordinates()[1]);
    }

    public void testReadPolygonZM() throws Exception {
        WKTReaderTest.assertEquals((Object)new Coordinate(7.0, 8.0, 9.0), (Object)this.reader.read("POLYGON((1 2 3, 4 5 6, 7 8 9, 1 2 3))").getCoordinates()[2]);
        WKTReaderTest.assertEquals((Object)new Coordinate(7.0, 8.0, 9.0), (Object)this.reader.read("POLYGONZ((1 2 3, 4 5 6, 7 8 9, 1 2 3))").getCoordinates()[2]);
        WKTReaderTest.assertEquals((Object)new Coordinate(7.0, 8.0, 9.0), (Object)this.reader.read("POLYGON Z((1 2 3, 4 5 6, 7 8 9, 1 2 3))").getCoordinates()[2]);
        WKTReaderTest.assertEquals((Object)new Coordinate(7.0, 8.0, 9.0), (Object)this.reader.read("POLYGONM((1 2 3, 4 5 6, 7 8 9, 1 2 3))").getCoordinates()[2]);
        WKTReaderTest.assertEquals((Object)new Coordinate(7.0, 8.0, 9.0), (Object)this.reader.read("POLYGON M((1 2 3, 4 5 6, 7 8 9, 1 2 3))").getCoordinates()[2]);
        WKTReaderTest.assertEquals((Object)new Coordinate(7.0, 8.0, 9.0), (Object)this.reader.read("POLYGONZM((1 2 3 10, 4 5 6 11, 7 8 9 12, 1 2 3 13))").getCoordinates()[2]);
        WKTReaderTest.assertEquals((Object)new Coordinate(7.0, 8.0, 9.0), (Object)this.reader.read("POLYGON ZM((1 2 3 10, 4 5 6 11, 7 8 9 12, 1 2 3 13))").getCoordinates()[2]);
        WKTReaderTest.assertEquals((Object)new Coordinate(7.0, 8.0, 9.0), (Object)this.reader.read("Polygon Zm((1 2 3 10, 4 5 6 11, 7 8 9 12, 1 2 3 13))").getCoordinates()[2]);
    }

    public void testReadMultiPolygonZM() throws Exception {
        WKTReaderTest.assertEquals((Object)new Coordinate(7.0, 8.0, 9.0), (Object)this.reader.read("MultiPolygon Zm(((1 2 3 10, 4 5 6 11, 7 8 9 12, 1 2 3 13)))").getCoordinates()[2]);
    }

    public void testReadLargeNumbers() throws Exception {
        PrecisionModel precisionModel = new PrecisionModel(1.0E9);
        GeometryFactory geometryFactory = new GeometryFactory(precisionModel, 0);
        WKTReader reader = new WKTReader(geometryFactory);
        Geometry point1 = reader.read("POINT (123456789.01234567890 10)");
        Point point2 = geometryFactory.createPoint(new Coordinate(1.2345678901234567E8, 10.0));
        WKTReaderTest.assertEquals((double)point1.getCoordinate().x, (double)point2.getCoordinate().x, (double)1.0E-7);
        WKTReaderTest.assertEquals((double)point1.getCoordinate().y, (double)point2.getCoordinate().y, (double)1.0E-7);
    }
}

