/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.gml2;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.locationtech.jts.generator.MultiGenerator;
import org.locationtech.jts.generator.PolygonGenerator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.gml2.WritingTestCase;
import org.xml.sax.SAXException;

public class StaticMultiPolygonTest
extends WritingTestCase {
    public StaticMultiPolygonTest(String arg) {
        super(arg);
    }

    public void testSingleMultiPolygonNoHoleRoundTrip() throws SAXException, IOException, ParserConfigurationException {
        PolygonGenerator pgc = new PolygonGenerator();
        pgc.setGeometryFactory(geometryFactory);
        pgc.setNumberPoints(10);
        MultiGenerator pg = new MultiGenerator(pgc);
        pg.setBoundingBox(new Envelope(0.0, 10.0, 0.0, 10.0));
        pg.setNumberGeometries(3);
        pg.setGeometryFactory(geometryFactory);
        MultiPolygon pt = (MultiPolygon)pg.create();
        this.checkRoundTrip((Geometry)pt);
    }

    public void testSingleMultiPolygonManyPointsNoHoleRoundTrip() throws SAXException, IOException, ParserConfigurationException {
        PolygonGenerator pgc = new PolygonGenerator();
        pgc.setGeometryFactory(geometryFactory);
        pgc.setGenerationAlgorithm(0);
        pgc.setNumberPoints(1000);
        MultiGenerator pg = new MultiGenerator(pgc);
        pg.setBoundingBox(new Envelope(0.0, 10.0, 0.0, 10.0));
        pg.setNumberGeometries(3);
        pg.setGeometryFactory(geometryFactory);
        MultiPolygon pt = (MultiPolygon)pg.create();
        this.checkRoundTrip((Geometry)pt);
    }

    public void testSingleMultiPolygonHolesRoundTrip() throws SAXException, IOException, ParserConfigurationException {
        PolygonGenerator pgc = new PolygonGenerator();
        pgc.setGeometryFactory(geometryFactory);
        pgc.setGenerationAlgorithm(0);
        pgc.setNumberPoints(10);
        pgc.setNumberHoles(4);
        MultiGenerator pg = new MultiGenerator(pgc);
        pg.setBoundingBox(new Envelope(0.0, 10.0, 0.0, 10.0));
        pg.setNumberGeometries(3);
        pg.setGeometryFactory(geometryFactory);
        MultiPolygon pt = (MultiPolygon)pg.create();
        this.checkRoundTrip((Geometry)pt);
    }

    public void testSingleMultiPolygonManyPointsHolesRoundTrip() throws SAXException, IOException, ParserConfigurationException {
        PolygonGenerator pgc = new PolygonGenerator();
        pgc.setGeometryFactory(geometryFactory);
        pgc.setGenerationAlgorithm(0);
        pgc.setNumberPoints(1000);
        pgc.setNumberHoles(4);
        MultiGenerator pg = new MultiGenerator(pgc);
        pg.setBoundingBox(new Envelope(0.0, 10.0, 0.0, 10.0));
        pg.setNumberGeometries(3);
        pg.setGeometryFactory(geometryFactory);
        MultiPolygon pt = (MultiPolygon)pg.create();
        this.checkRoundTrip((Geometry)pt);
    }

    public void testSingleMultiPolygonManyPointsManyHolesRoundTrip() throws SAXException, IOException, ParserConfigurationException {
        PolygonGenerator pgc = new PolygonGenerator();
        pgc.setGeometryFactory(geometryFactory);
        pgc.setGenerationAlgorithm(0);
        pgc.setNumberPoints(100);
        pgc.setNumberHoles(100);
        MultiGenerator pg = new MultiGenerator(pgc);
        pg.setBoundingBox(new Envelope(0.0, 10.0, 0.0, 10.0));
        pg.setNumberGeometries(3);
        pg.setGeometryFactory(geometryFactory);
        MultiPolygon pt = (MultiPolygon)pg.create();
        this.checkRoundTrip((Geometry)pt);
    }
}

