/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.gml2;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.locationtech.jts.generator.PolygonGenerator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.gml2.WritingTestCase;
import org.xml.sax.SAXException;

public class StaticPolygonTest
extends WritingTestCase {
    public StaticPolygonTest(String arg) {
        super(arg);
    }

    public void testSinglePolygonNoHoleRoundTrip() throws IOException, SAXException, ParserConfigurationException {
        PolygonGenerator pg = new PolygonGenerator();
        pg.setGeometryFactory(geometryFactory);
        pg.setBoundingBox(new Envelope(0.0, 10.0, 0.0, 10.0));
        pg.setNumberPoints(10);
        Polygon pt = (Polygon)pg.create();
        this.checkRoundTrip((Geometry)pt);
    }

    public void testSinglePolygonManyPointsNoHoleRoundTrip() throws IOException, SAXException, ParserConfigurationException {
        PolygonGenerator pg = new PolygonGenerator();
        pg.setGeometryFactory(geometryFactory);
        pg.setBoundingBox(new Envelope(0.0, 10.0, 0.0, 10.0));
        pg.setGenerationAlgorithm(0);
        pg.setNumberPoints(1000);
        Polygon pt = (Polygon)pg.create();
        this.checkRoundTrip((Geometry)pt);
    }

    public void testSinglePolygonHolesRoundTrip() throws SAXException, IOException, ParserConfigurationException {
        PolygonGenerator pg = new PolygonGenerator();
        pg.setGeometryFactory(geometryFactory);
        pg.setBoundingBox(new Envelope(0.0, 10.0, 0.0, 10.0));
        pg.setNumberPoints(10);
        pg.setNumberHoles(4);
        Polygon pt = (Polygon)pg.create();
        this.checkRoundTrip((Geometry)pt);
    }

    public void testSinglePolygonManyPointsHolesRoundTrip() throws SAXException, IOException, ParserConfigurationException {
        PolygonGenerator pg = new PolygonGenerator();
        pg.setGeometryFactory(geometryFactory);
        pg.setBoundingBox(new Envelope(0.0, 10.0, 0.0, 10.0));
        pg.setGenerationAlgorithm(0);
        pg.setNumberPoints(1000);
        pg.setNumberHoles(4);
        Polygon pt = (Polygon)pg.create();
        this.checkRoundTrip((Geometry)pt);
    }

    public void testSinglePolygonManyPointsManyHolesRoundTrip() throws SAXException, IOException, ParserConfigurationException {
        PolygonGenerator pg = new PolygonGenerator();
        pg.setGeometryFactory(geometryFactory);
        pg.setBoundingBox(new Envelope(0.0, 10.0, 0.0, 10.0));
        pg.setGenerationAlgorithm(0);
        pg.setNumberPoints(100);
        pg.setNumberHoles(100);
        Polygon pt = (Polygon)pg.create();
        this.checkRoundTrip((Geometry)pt);
    }
}

