/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import junit.framework.TestCase;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public abstract class AbstractIndexedLineTest
extends TestCase {
    private WKTReader reader = new WKTReader();
    static final double TOLERANCE_DIST = 0.001;

    public AbstractIndexedLineTest(String name) {
        super(name);
    }

    public void testFirst() {
        this.runOffsetTest("LINESTRING (0 0, 20 20)", "POINT(20 20)", 0.0, "POINT (20 20)");
    }

    public void testML() {
        this.runIndicesOfThenExtract("MULTILINESTRING ((0 0, 10 10), (20 20, 30 30))", "MULTILINESTRING ((1 1, 10 10), (20 20, 25 25))");
    }

    public void testPartOfSegmentNoVertex() {
        this.runIndicesOfThenExtract("LINESTRING (0 0, 10 10, 20 20)", "LINESTRING (1 1, 9 9)");
    }

    public void testPartOfSegmentContainingVertex() {
        this.runIndicesOfThenExtract("LINESTRING (0 0, 10 10, 20 20)", "LINESTRING (5 5, 10 10, 15 15)");
    }

    public void testPartOfSegmentContainingDuplicateCoords() {
        this.runIndicesOfThenExtract("LINESTRING (0 0, 10 10, 10 10, 20 20)", "LINESTRING (5 5, 10 10, 10 10, 15 15)");
    }

    public void testLoopWithStartSubLine() {
        this.runIndicesOfThenExtract("LINESTRING (0 0, 0 10, 10 10, 10 0, 0 0)", "LINESTRING (0 0, 0 10, 10 10)");
    }

    public void testLoopWithEndingSubLine() {
        this.runIndicesOfThenExtract("LINESTRING (0 0, 0 10, 10 10, 10 0, 0 0)", "LINESTRING (10 10, 10 0, 0 0)");
    }

    public void testLoopWithIdenticalSubLine() {
        this.runIndicesOfThenExtract("LINESTRING (0 0, 0 10, 10 10, 10 0, 0 0)", "LINESTRING (0 0, 0 10, 10 10, 10 0, 0 0)");
    }

    public void testZeroLenSubLineAtStart() {
        this.runIndicesOfThenExtract("LINESTRING (0 0, 0 10, 10 10, 10 0, 0 0)", "LINESTRING (0 0, 0 0)");
    }

    public void testZeroLenSubLineAtMidVertex() {
        this.runIndicesOfThenExtract("LINESTRING (0 0, 0 10, 10 10, 10 0, 0 0)", "LINESTRING (10 10, 10 10)");
    }

    public void testIndexOfAfterSquare() {
        this.runIndexOfAfterTest("LINESTRING (0 0, 0 10, 10 10, 10 0, 0 0)", "POINT (0 0)");
    }

    public void testIndexOfAfterRibbon() {
        this.runIndexOfAfterTest("LINESTRING (0 0, 0 60, 50 60, 50 20, -20 20)", "POINT (0 20)");
        this.runIndexOfAfterTest("LINESTRING (0 0, 0 60, 50 60, 50 20, -20 20)", "POINT (0 20)", "POINT (30 60)");
    }

    public void testIndexOfAfterBeyondEndRibbon() {
        this.runIndexOfAfterTest("LINESTRING (0 0, 0 60, 50 60, 50 20, -20 20)", "POINT (-30 20)", "POINT (-20 20)");
    }

    public void testOffsetStartPoint() {
        this.runOffsetTest("LINESTRING (0 0, 10 10, 20 20)", "POINT(0 0)", 1.0, "POINT (-0.7071067811865475 0.7071067811865475)");
        this.runOffsetTest("LINESTRING (0 0, 10 10, 20 20)", "POINT(0 0)", -1.0, "POINT (0.7071067811865475 -0.7071067811865475)");
        this.runOffsetTest("LINESTRING (0 0, 10 10, 20 20)", "POINT(10 10)", 5.0, "POINT (6.464466094067262 13.535533905932738)");
        this.runOffsetTest("LINESTRING (0 0, 10 10, 20 20)", "POINT(10 10)", -5.0, "POINT (13.535533905932738 6.464466094067262)");
    }

    public void testOffsetStartPointRepeatedPoint() {
        this.runOffsetTest("LINESTRING (0 0, 10 10, 10 10, 20 20)", "POINT(0 0)", 1.0, "POINT (-0.7071067811865475 0.7071067811865475)");
        this.runOffsetTest("LINESTRING (0 0, 10 10, 10 10, 20 20)", "POINT(0 0)", -1.0, "POINT (0.7071067811865475 -0.7071067811865475)");
    }

    public void testOffsetEndPoint() {
        this.runOffsetTest("LINESTRING (0 0, 20 20)", "POINT(20 20)", 0.0, "POINT (20 20)");
        this.runOffsetTest("LINESTRING (0 0, 13 13, 20 20)", "POINT(20 20)", 0.0, "POINT (20 20)");
        this.runOffsetTest("LINESTRING (0 0, 10 0, 20 0)", "POINT(20 0)", 1.0, "POINT (20 1)");
        this.runOffsetTest("LINESTRING (0 0, 20 0)", "POINT(10 0)", 1.0, "POINT (10 1)");
        this.runOffsetTest("MULTILINESTRING ((0 0, 10 0), (10 0, 20 0))", "POINT(10 0)", -1.0, "POINT (10 -1)");
        this.runOffsetTest("MULTILINESTRING ((0 0, 10 0), (10 0, 20 0))", "POINT(20 0)", 1.0, "POINT (20 1)");
    }

    protected Geometry read(String wkt) {
        try {
            return this.reader.read(wkt);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void runIndicesOfThenExtract(String inputStr, String subLineStr) {
        Geometry input = this.read(inputStr);
        Geometry subLine = this.read(subLineStr);
        Geometry result = this.indicesOfThenExtract(input, subLine);
        this.checkExpected(result, subLineStr);
    }

    protected void checkExpected(Geometry result, String expected) {
        Geometry subLine = this.read(expected);
        boolean isEqual = result.equalsExact(subLine, 1.0E-5);
        if (!isEqual) {
            System.out.println("Computed result is: " + result);
        }
        AbstractIndexedLineTest.assertTrue((boolean)isEqual);
    }

    protected abstract Geometry indicesOfThenExtract(Geometry var1, Geometry var2);

    protected void runIndexOfAfterTest(String inputStr, String testPtWKT) {
        Geometry input = this.read(inputStr);
        Geometry testPoint = this.read(testPtWKT);
        Coordinate testPt = testPoint.getCoordinate();
        boolean resultOK = this.indexOfAfterCheck(input, testPt);
        AbstractIndexedLineTest.assertTrue((boolean)resultOK);
    }

    protected void runIndexOfAfterTest(String inputStr, String testPtWKT, String afterPtWKT) {
        Geometry input = this.read(inputStr);
        Geometry testPoint = this.read(testPtWKT);
        Coordinate testPt = testPoint.getCoordinate();
        Geometry afterPoint = this.read(afterPtWKT);
        Coordinate afterPt = afterPoint.getCoordinate();
        boolean resultOK = this.indexOfAfterCheck(input, testPt, afterPt);
        AbstractIndexedLineTest.assertTrue((boolean)resultOK);
    }

    protected abstract boolean indexOfAfterCheck(Geometry var1, Coordinate var2);

    protected abstract boolean indexOfAfterCheck(Geometry var1, Coordinate var2, Coordinate var3);

    protected void runOffsetTest(String inputWKT, String testPtWKT, double offsetDistance, String expectedPtWKT) {
        boolean isOk;
        Geometry input = this.read(inputWKT);
        Geometry testPoint = this.read(testPtWKT);
        Geometry expectedPoint = this.read(expectedPtWKT);
        Coordinate testPt = testPoint.getCoordinate();
        Coordinate expectedPt = expectedPoint.getCoordinate();
        Coordinate offsetPt = this.extractOffsetAt(input, testPt, offsetDistance);
        boolean bl = isOk = offsetPt.distance(expectedPt) < 0.001;
        if (!isOk) {
            System.out.println("Expected = " + expectedPoint + "  Actual = " + offsetPt);
        }
        AbstractIndexedLineTest.assertTrue((boolean)isOk);
    }

    protected abstract Coordinate extractOffsetAt(Geometry var1, Coordinate var2, double var3);
}

