/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.linearref.AbstractIndexedLineTest;
import org.locationtech.jts.linearref.LengthIndexedLine;

public class LengthIndexedLineTest
extends AbstractIndexedLineTest {
    public static void main(String[] args) {
        TestRunner.run(LengthIndexedLineTest.class);
    }

    public LengthIndexedLineTest(String name) {
        super(name);
    }

    public void testExtractLineBothIndicesAtEndpointXXX() {
        this.checkExtractLine("MULTILINESTRING ((0 0, 10 0), (20 0, 25 0, 30 0))", -10.0, 10.0, "LINESTRING (10 0, 10 0)");
    }

    public void testExtractLineBeyondRange() {
        this.checkExtractLine("LINESTRING (0 0, 10 10)", -100.0, 100.0, "LINESTRING (0 0, 10 10)");
    }

    public void testExtractLineReverse() {
        this.checkExtractLine("LINESTRING (0 0, 10 0)", 9.0, 1.0, "LINESTRING (9 0, 1 0)");
    }

    public void testExtractLineReverseMulti() {
        this.checkExtractLine("MULTILINESTRING ((0 0, 10 0), (20 0, 25 0, 30 0))", 19.0, 1.0, "MULTILINESTRING ((29 0, 25 0, 20 0), (10 0, 1 0))");
    }

    public void testExtractLineNegative() {
        this.checkExtractLine("LINESTRING (0 0, 10 0)", -9.0, -1.0, "LINESTRING (1 0, 9 0)");
    }

    public void testExtractLineNegativeReverse() {
        this.checkExtractLine("LINESTRING (0 0, 10 0)", -1.0, -9.0, "LINESTRING (9 0, 1 0)");
    }

    public void testExtractLineIndexAtEndpoint() {
        this.checkExtractLine("MULTILINESTRING ((0 0, 10 0), (20 0, 25 0, 30 0))", 10.0, -1.0, "LINESTRING (20 0, 25 0, 29 0)");
    }

    public void testExtractLineIndexAtEndpointWithZeroLenComponents() {
        this.checkExtractLine("MULTILINESTRING ((0 0, 10 0), (10 0, 10 0), (20 0, 25 0, 30 0))", 10.0, -1.0, "LINESTRING (20 0, 25 0, 29 0)");
        this.checkExtractLine("MULTILINESTRING ((0 0, 10 0), (10 0, 10 0), (20 0, 25 0, 30 0))", 5.0, 10.0, "LINESTRING (5 0, 10 0)");
        this.checkExtractLine("MULTILINESTRING ((0 0, 10 0), (10 0, 10 0), (10 0, 10 0), (20 0, 25 0, 30 0))", 10.0, 10.0, "LINESTRING (10 0, 10 0)");
        this.checkExtractLine("MULTILINESTRING ((0 0, 10 0), (10 0, 10 0), (10 0, 10 0), (10 0, 10 0), (20 0, 25 0, 30 0))", 10.0, -10.0, "LINESTRING (10 0, 10 0)");
    }

    public void testExtractLineBothIndicesAtEndpoint() {
        this.checkExtractLine("MULTILINESTRING ((0 0, 10 0), (20 0, 25 0, 30 0))", 10.0, 10.0, "LINESTRING (10 0, 10 0)");
    }

    public void testExtractLineBothIndicesAtEndpointNegative() {
        this.checkExtractLine("MULTILINESTRING ((0 0, 10 0), (20 0, 25 0, 30 0))", -10.0, 10.0, "LINESTRING (10 0, 10 0)");
    }

    public void testProjectExtractPoint() {
        Geometry linearGeom = this.read("MULTILINESTRING ((0 2, 0 0), (-1 1, 1 1))");
        LengthIndexedLine indexedLine = new LengthIndexedLine(linearGeom);
        double index = indexedLine.project(new Coordinate(1.0, 0.0));
        Coordinate pt = indexedLine.extractPoint(index);
        LengthIndexedLineTest.assertTrue((boolean)pt.equals((Object)new Coordinate(0.0, 0.0)));
    }

    public void testExtractPointBeyondRange() {
        Geometry linearGeom = this.read("LINESTRING (0 0, 10 10)");
        LengthIndexedLine indexedLine = new LengthIndexedLine(linearGeom);
        Coordinate pt = indexedLine.extractPoint(100.0);
        LengthIndexedLineTest.assertTrue((boolean)pt.equals((Object)new Coordinate(10.0, 10.0)));
        Coordinate pt2 = indexedLine.extractPoint(0.0);
        LengthIndexedLineTest.assertTrue((boolean)pt2.equals((Object)new Coordinate(0.0, 0.0)));
    }

    public void testProjectPointWithDuplicateCoords() {
        Geometry linearGeom = this.read("LINESTRING (0 0, 10 0, 10 0, 20 0)");
        LengthIndexedLine indexedLine = new LengthIndexedLine(linearGeom);
        double projIndex = indexedLine.project(new Coordinate(10.0, 1.0));
        LengthIndexedLineTest.assertTrue((projIndex == 10.0 ? 1 : 0) != 0);
    }

    @Override
    public void testOffsetStartPointRepeatedPoint() {
        this.runOffsetTest("LINESTRING (0 0, 10 10, 10 10, 20 20)", "POINT(0 0)", 1.0, "POINT (-0.7071067811865475 0.7071067811865475)");
        this.runOffsetTest("LINESTRING (0 0, 10 10, 10 10, 20 20)", "POINT(0 0)", -1.0, "POINT (0.7071067811865475 -0.7071067811865475)");
        this.runOffsetTest("LINESTRING (0 0, 10 10, 10 10, 20 20)", "POINT(10 10)", 5.0, "POINT (6.464466094067262 13.535533905932738)");
        this.runOffsetTest("LINESTRING (0 0, 10 10, 10 10, 20 20)", "POINT(10 10)", -5.0, "POINT (13.535533905932738 6.464466094067262)");
    }

    public void testComputeZ() {
        Geometry linearGeom = this.read("LINESTRING (0 0 0, 10 10 10)");
        LengthIndexedLine indexedLine = new LengthIndexedLine(linearGeom);
        double projIndex = indexedLine.project(new Coordinate(5.0, 5.0));
        Coordinate projPt = indexedLine.extractPoint(projIndex);
        LengthIndexedLineTest.assertTrue((boolean)projPt.equals3D(new Coordinate(5.0, 5.0, 5.0)));
    }

    public void testComputeZNaN() {
        Geometry linearGeom = this.read("LINESTRING (0 0, 10 10 10)");
        LengthIndexedLine indexedLine = new LengthIndexedLine(linearGeom);
        double projIndex = indexedLine.project(new Coordinate(5.0, 5.0));
        Coordinate projPt = indexedLine.extractPoint(projIndex);
        LengthIndexedLineTest.assertTrue((boolean)Double.isNaN(projPt.z));
    }

    private void checkExtractLine(String wkt, double start, double end, String expected) {
        Geometry linearGeom = this.read(wkt);
        LengthIndexedLine indexedLine = new LengthIndexedLine(linearGeom);
        Geometry result = indexedLine.extractLine(start, end);
        this.checkExpected(result, expected);
    }

    @Override
    protected Geometry indicesOfThenExtract(Geometry linearGeom, Geometry subLine) {
        LengthIndexedLine indexedLine = new LengthIndexedLine(linearGeom);
        double[] loc = indexedLine.indicesOf(subLine);
        Geometry result = indexedLine.extractLine(loc[0], loc[1]);
        return result;
    }

    @Override
    protected boolean indexOfAfterCheck(Geometry linearGeom, Coordinate testPt) {
        LengthIndexedLine indexedLine = new LengthIndexedLine(linearGeom);
        double loc1 = indexedLine.indexOf(testPt);
        double loc2 = indexedLine.indexOfAfter(testPt, loc1);
        if (loc2 <= loc1) {
            return false;
        }
        Coordinate pt1 = indexedLine.extractPoint(loc1);
        Coordinate pt2 = indexedLine.extractPoint(loc2);
        if (!pt1.equals2D(testPt)) {
            return false;
        }
        return pt2.equals2D(testPt);
    }

    @Override
    protected boolean indexOfAfterCheck(Geometry linearGeom, Coordinate testPt, Coordinate checkPt) {
        LengthIndexedLine indexedLine = new LengthIndexedLine(linearGeom);
        double checkLoc = indexedLine.indexOf(checkPt);
        double testLoc = indexedLine.indexOfAfter(testPt, checkLoc);
        return !(testLoc < checkLoc);
    }

    @Override
    protected Coordinate extractOffsetAt(Geometry linearGeom, Coordinate testPt, double offsetDistance) {
        LengthIndexedLine indexedLine = new LengthIndexedLine(linearGeom);
        double index = indexedLine.indexOf(testPt);
        return indexedLine.extractPoint(index, offsetDistance);
    }
}

