/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.math.DD;

public class DDIOTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(DDIOTest.class);
    }

    public DDIOTest(String name) {
        super(name);
    }

    public void testWriteStandardNotation() {
        this.checkStandardNotation(1.0, "1.0");
        this.checkStandardNotation(0.0, "0.0");
        this.checkStandardNotation(DD.valueOf((double)1.0E12).subtract(DD.valueOf((double)1.0)), "999999999999.0");
        this.checkStandardNotation(DD.valueOf((double)1.0E14).subtract(DD.valueOf((double)1.0)), "99999999999999.0");
        this.checkStandardNotation(DD.valueOf((double)1.0E16).subtract(DD.valueOf((double)1.0)), "9999999999999999.0");
        DD num8Dec = DD.valueOf((double)-3.79363639E8).divide(DD.valueOf((double)1.0E8));
        this.checkStandardNotation(num8Dec, "-3.79363639");
        this.checkStandardNotation(new DD(-3.79363639, 8.039137357367426E-17), "-3.7936363900000000000000000");
        this.checkStandardNotation(DD.valueOf((double)34.0).divide(DD.valueOf((double)1000.0)), "0.034");
        this.checkStandardNotation(1050.0, "1050.0");
        this.checkStandardNotation(0.34, "0.34000000000000002442490654175344");
        this.checkStandardNotation(DD.valueOf((double)34.0).divide(DD.valueOf((double)100.0)), "0.34");
        this.checkStandardNotation(14.0, "14.0");
    }

    private void checkStandardNotation(double x, String expectedStr) {
        this.checkStandardNotation(DD.valueOf((double)x), expectedStr);
    }

    private void checkStandardNotation(DD x, String expectedStr) {
        String xStr = x.toStandardNotation();
        DDIOTest.assertEquals((Object)expectedStr, (Object)xStr);
    }

    public void testWriteSciNotation() {
        this.checkSciNotation(0.0, "0.0E0");
        this.checkSciNotation(1.05E10, "1.05E10");
        this.checkSciNotation(0.34, "3.4000000000000002442490654175344E-1");
        this.checkSciNotation(DD.valueOf((double)34.0).divide(DD.valueOf((double)100.0)), "3.4E-1");
        this.checkSciNotation(14.0, "1.4E1");
    }

    private void checkSciNotation(double x, String expectedStr) {
        this.checkSciNotation(DD.valueOf((double)x), expectedStr);
    }

    private void checkSciNotation(DD x, String expectedStr) {
        String xStr = x.toSciNotation();
        DDIOTest.assertEquals((Object)xStr, (Object)expectedStr);
    }

    public void testParseInt() {
        this.checkParse("0", 0.0, 1.0E-32);
        this.checkParse("00", 0.0, 1.0E-32);
        this.checkParse("000", 0.0, 1.0E-32);
        this.checkParse("1", 1.0, 1.0E-32);
        this.checkParse("100", 100.0, 1.0E-32);
        this.checkParse("00100", 100.0, 1.0E-32);
        this.checkParse("-1", -1.0, 1.0E-32);
        this.checkParse("-01", -1.0, 1.0E-32);
        this.checkParse("-123", -123.0, 1.0E-32);
        this.checkParse("-00123", -123.0, 1.0E-32);
    }

    public void testParseStandardNotation() {
        this.checkParse("1.0000000", 1.0, 1.0E-32);
        this.checkParse("1.0", 1.0, 1.0E-32);
        this.checkParse("1.", 1.0, 1.0E-32);
        this.checkParse("01.", 1.0, 1.0E-32);
        this.checkParse("-1.0", -1.0, 1.0E-32);
        this.checkParse("-1.", -1.0, 1.0E-32);
        this.checkParse("-01.0", -1.0, 1.0E-32);
        this.checkParse("-123.0", -123.0, 1.0E-32);
        this.checkParse("1.4", DD.valueOf((double)14.0).divide(DD.valueOf((double)10.0)), 1.0E-30);
        this.checkParse("39.5", 39.5, 1.0E-30);
        this.checkParse("-39.5", -39.5, 1.0E-30);
    }

    public void testParseSciNotation() {
        this.checkParse("1.05e10", 1.05E10, 1.0E-32);
        this.checkParse("01.05e10", 1.05E10, 1.0E-32);
        this.checkParse("12.05e10", 1.205E11, 1.0E-32);
        this.checkParse("-1.05e10", -1.05E10, 1.0E-32);
        this.checkParse("1.05e-10", DD.valueOf((double)105.0).divide(DD.valueOf((double)100.0)).divide(DD.valueOf((double)1.0E10)), 1.0E-32);
        this.checkParse("-1.05e-10", DD.valueOf((double)105.0).divide(DD.valueOf((double)100.0)).divide(DD.valueOf((double)1.0E10)).negate(), 1.0E-32);
    }

    private void checkParse(String str, double expectedVal, double errBound) {
        this.checkParse(str, new DD(expectedVal), errBound);
    }

    private void checkParse(String str, DD expectedVal, double relErrBound) {
        DD xdd = DD.parse((String)str);
        double err = xdd.subtract(expectedVal).doubleValue();
        double xddd = xdd.doubleValue();
        double relErr = xddd == 0.0 ? err : Math.abs(err / xddd);
        DDIOTest.assertTrue((String)("parsing '" + str + "' results in " + xdd.toString() + " ( " + xdd.dump() + ") != " + expectedVal + "\n  err =" + err + ", relerr =" + relErr), (relErr <= relErrBound ? 1 : 0) != 0);
    }

    public void testParseError() {
        this.checkParseError("-1.05E2w");
        this.checkParseError("%-1.05E2w");
        this.checkParseError("-1.0512345678t");
    }

    private void checkParseError(String str) {
        boolean foundParseError = false;
        try {
            DD.parse((String)str);
        }
        catch (NumberFormatException ex) {
            foundParseError = true;
        }
        DDIOTest.assertTrue((boolean)foundParseError);
    }

    public void tesWritetRepeatedSqrt() {
        this.writeRepeatedSqrt(DD.valueOf((double)1.0));
        this.writeRepeatedSqrt(DD.valueOf((double)0.999999999999));
        this.writeRepeatedSqrt(DD.PI.divide(DD.valueOf((double)10.0)));
    }

    private void writeRepeatedSqrt(DD xdd) {
        int count = 0;
        while (xdd.doubleValue() > 1.0E-300) {
            ++count;
            double x = xdd.doubleValue();
            DD xSqrt = xdd.sqrt();
            String s = xSqrt.toString();
            DD xSqrt2 = DD.parse((String)s);
            DD xx = xSqrt2.multiply(xSqrt2);
            double err = Math.abs(xx.doubleValue() - x);
            xdd = xSqrt;
            DD distFrom1DD = xSqrt.subtract(DD.valueOf((double)1.0));
            double distFrom1 = distFrom1DD.doubleValue();
            if (!(Math.abs(distFrom1) < 1.0E-40)) continue;
            break;
        }
    }

    public void testWriteRepeatedSqr() {
        this.writeRepeatedSqr(DD.valueOf((double)0.9));
        this.writeRepeatedSqr(DD.PI.divide(DD.valueOf((double)10.0)));
    }

    private void writeRepeatedSqr(DD xdd) {
        if (xdd.ge(DD.valueOf((double)1.0))) {
            throw new IllegalArgumentException("Argument must be < 1");
        }
        int count = 0;
        while (xdd.doubleValue() > 1.0E-300) {
            if (++count == 100) {
                // empty if block
            }
            double x = xdd.doubleValue();
            DD xSqr = xdd.sqr();
            String s = xSqr.toString();
            DD xSqr2 = DD.parse((String)s);
            xdd = xSqr;
        }
    }

    public void testWriteSquaresStress() {
        for (int i = 1; i < 10000; ++i) {
            this.writeAndReadSqrt(i);
        }
    }

    private void writeAndReadSqrt(double x) {
        DD xdd = DD.valueOf((double)x);
        DD xSqrt = xdd.sqrt();
        String s = xSqrt.toString();
        DD xSqrt2 = DD.parse((String)s);
        DD xx = xSqrt2.multiply(xSqrt2);
        String xxStr = xx.toString();
        DD xx2 = DD.parse((String)xxStr);
        double err = Math.abs(xx2.doubleValue() - x);
        DDIOTest.assertTrue((err < 1.0E-10 ? 1 : 0) != 0);
    }
}

