/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.noding.FastNodingValidator;
import org.locationtech.jts.noding.SegmentStringUtil;
import test.jts.GeometryTestCase;

public class FastNodingValidatorTest
extends GeometryTestCase {
    private static final String[] VERTEX_INT = new String[]{"LINESTRING (100 100, 200 200, 300 300)", "LINESTRING (100 300, 200 200)"};
    private static final String[] INTERIOR_INT = new String[]{"LINESTRING (100 100, 300 300)", "LINESTRING (100 300, 300 100)"};
    private static final String[] NO_INT = new String[]{"LINESTRING (100 100, 200 200)", "LINESTRING (200 200, 300 300)", "LINESTRING (100 300, 200 200)"};
    private static final String[] SELF_INTERIOR_INT = new String[]{"LINESTRING (100 100, 300 300, 300 100, 100 300)"};
    private static final String[] SELF_VERTEX_INT = new String[]{"LINESTRING (100 100, 200 200, 300 300, 400 200, 200 200)"};

    public FastNodingValidatorTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(FastNodingValidatorTest.class);
    }

    public void testInteriorIntersection() {
        this.checkValid(INTERIOR_INT, false);
        this.checkIntersection(INTERIOR_INT, "POINT(200 200)");
    }

    public void testVertexIntersection() {
        this.checkValid(VERTEX_INT, false);
    }

    public void testNoIntersection() {
        this.checkValid(NO_INT, true);
    }

    public void testSelfInteriorIntersection() {
        this.checkValid(SELF_INTERIOR_INT, false);
    }

    public void testSelfVertexIntersection() {
        this.checkValid(SELF_VERTEX_INT, false);
    }

    private void checkValid(String[] inputWKT, boolean isValidExpected) {
        List input = this.readList(inputWKT);
        List segStrings = FastNodingValidatorTest.toSegmentStrings(input);
        FastNodingValidator fnv = new FastNodingValidator((Collection)segStrings);
        boolean isValid = fnv.isValid();
        FastNodingValidatorTest.assertTrue((isValidExpected == isValid ? 1 : 0) != 0);
    }

    private void checkIntersection(String[] inputWKT, String expectedWKT) {
        List input = this.readList(inputWKT);
        Geometry expected = this.read(expectedWKT);
        Coordinate[] pts = expected.getCoordinates();
        CoordinateList intPtsExpected = new CoordinateList(pts);
        List segStrings = FastNodingValidatorTest.toSegmentStrings(input);
        List intPtsActual = FastNodingValidator.computeIntersections((Collection)segStrings);
        boolean isSameNumberOfIntersections = intPtsExpected.size() == intPtsActual.size();
        FastNodingValidatorTest.assertTrue((boolean)isSameNumberOfIntersections);
        this.checkIntersections(intPtsActual, (List)intPtsExpected);
    }

    private void checkIntersections(List intPtsActual, List intPtsExpected) {
        for (int i = 0; i < intPtsActual.size(); ++i) {
            Coordinate ptActual = (Coordinate)intPtsActual.get(i);
            Coordinate ptExpected = (Coordinate)intPtsExpected.get(i);
            boolean isEqual = ptActual.equals2D(ptExpected);
            FastNodingValidatorTest.assertTrue((boolean)isEqual);
        }
    }

    private static List toSegmentStrings(Collection geoms) {
        ArrayList segStrings = new ArrayList();
        for (Object geom : geoms) {
            segStrings.addAll(SegmentStringUtil.extractSegmentStrings((Geometry)((Geometry)geom)));
        }
        return segStrings;
    }
}

