/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.noding.Octant;
import org.locationtech.jts.noding.SegmentPointComparator;

public class SegmentPointComparatorFullTest
extends TestCase {
    private PrecisionModel pm = new PrecisionModel(1.0);

    public SegmentPointComparatorFullTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(SegmentPointComparatorFullTest.class);
    }

    public void testQuadrant0() {
        this.checkSegment(100.0, 0.0);
        this.checkSegment(100.0, 50.0);
        this.checkSegment(100.0, 100.0);
        this.checkSegment(100.0, 150.0);
        this.checkSegment(0.0, 100.0);
    }

    public void testQuadrant4() {
        this.checkSegment(100.0, -50.0);
        this.checkSegment(100.0, -100.0);
        this.checkSegment(100.0, -150.0);
        this.checkSegment(0.0, -100.0);
    }

    public void testQuadrant1() {
        this.checkSegment(-100.0, 0.0);
        this.checkSegment(-100.0, 50.0);
        this.checkSegment(-100.0, 100.0);
        this.checkSegment(-100.0, 150.0);
    }

    public void testQuadrant2() {
        this.checkSegment(-100.0, 0.0);
        this.checkSegment(-100.0, -50.0);
        this.checkSegment(-100.0, -100.0);
        this.checkSegment(-100.0, -150.0);
    }

    private void checkSegment(double x, double y) {
        Coordinate seg0 = new Coordinate(0.0, 0.0);
        Coordinate seg1 = new Coordinate(x, y);
        LineSegment seg = new LineSegment(seg0, seg1);
        for (int i = 0; i < 4; ++i) {
            double dist = i;
            double gridSize = 1.0 / this.pm.getScale();
            this.checkPointsAtDistance(seg, dist, dist + 1.0 * gridSize);
            this.checkPointsAtDistance(seg, dist, dist + 2.0 * gridSize);
            this.checkPointsAtDistance(seg, dist, dist + 3.0 * gridSize);
            this.checkPointsAtDistance(seg, dist, dist + 4.0 * gridSize);
        }
    }

    private Coordinate computePoint(LineSegment seg, double dist) {
        double dx = seg.p1.x - seg.p0.x;
        double dy = seg.p1.y - seg.p0.y;
        double len = seg.getLength();
        Coordinate pt = new Coordinate(dist * dx / len, dist * dy / len);
        this.pm.makePrecise(pt);
        return pt;
    }

    private void checkPointsAtDistance(LineSegment seg, double dist0, double dist1) {
        Coordinate p1;
        Coordinate p0 = this.computePoint(seg, dist0);
        if (p0.equals((Object)(p1 = this.computePoint(seg, dist1)))) {
            this.checkNodePosition(seg, p0, p1, 0);
        } else {
            this.checkNodePosition(seg, p0, p1, -1);
            this.checkNodePosition(seg, p1, p0, 1);
        }
    }

    private void checkNodePosition(LineSegment seg, Coordinate p0, Coordinate p1, int expectedPositionValue) {
        int octant = Octant.octant((Coordinate)seg.p0, (Coordinate)seg.p1);
        int posValue = SegmentPointComparator.compare((int)octant, (Coordinate)p0, (Coordinate)p1);
        SegmentPointComparatorFullTest.assertTrue((posValue == expectedPositionValue ? 1 : 0) != 0);
    }
}

