/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.IsSimpleOp;

public class IsSimpleTest
extends TestCase {
    private static final double TOLERANCE = 5.0E-5;
    private GeometryFactory fact = new GeometryFactory();
    private WKTReader rdr = new WKTReader(this.fact);

    public static void main(String[] args) {
        TestRunner.run(IsSimpleTest.class);
    }

    public IsSimpleTest(String name) {
        super(name);
    }

    public void test2TouchAtEndpoint() throws Exception {
        String a = "MULTILINESTRING((0 1, 1 1, 2 1), (0 0, 1 0, 2 1))";
        this.runIsSimpleTest(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, true, new Coordinate(2.0, 1.0));
        this.runIsSimpleTest(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true, new Coordinate(2.0, 1.0));
    }

    public void test3TouchAtEndpoint() throws Exception {
        String a = "MULTILINESTRING ((0 1, 1 1, 2 1),   (0 0, 1 0, 2 1),  (0 2, 1 2, 2 1))";
        this.runIsSimpleTest(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, true, new Coordinate(2.0, 1.0));
        this.runIsSimpleTest(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true, new Coordinate(2.0, 1.0));
    }

    public void testCross() throws Exception {
        String a = "MULTILINESTRING ((20 120, 120 20), (20 20, 120 120))";
        this.runIsSimpleTest(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, false, new Coordinate(70.0, 70.0));
        this.runIsSimpleTest(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, false, new Coordinate(70.0, 70.0));
    }

    public void testMultiLineStringWithRingTouchAtEndpoint() throws Exception {
        String a = "MULTILINESTRING ((100 100, 20 20, 200 20, 100 100), (100 200, 100 100))";
        this.runIsSimpleTest(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, false, new Coordinate(100.0, 100.0));
        this.runIsSimpleTest(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true);
    }

    public void testRing() throws Exception {
        String a = "LINESTRING (100 100, 20 20, 200 20, 100 100)";
        this.runIsSimpleTest(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, true);
        this.runIsSimpleTest(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true);
    }

    private void runIsSimpleTest(String wkt, BoundaryNodeRule bnRule, boolean expectedResult) throws ParseException {
        this.runIsSimpleTest(wkt, bnRule, expectedResult, null);
    }

    private void runIsSimpleTest(String wkt, BoundaryNodeRule bnRule, boolean expectedResult, Coordinate expectedLocation) throws ParseException {
        Geometry g = this.rdr.read(wkt);
        IsSimpleOp op = new IsSimpleOp(g, bnRule);
        boolean isSimple = false;
        isSimple = op.isSimple();
        Coordinate nonSimpleLoc = op.getNonSimpleLocation();
        IsSimpleTest.assertTrue((isSimple || nonSimpleLoc != null ? 1 : 0) != 0);
        IsSimpleTest.assertTrue((expectedResult == isSimple ? 1 : 0) != 0);
        if (!isSimple && expectedLocation != null) {
            IsSimpleTest.assertTrue((expectedLocation.distance(nonSimpleLoc) < 5.0E-5 ? 1 : 0) != 0);
        }
    }
}

