/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.operation.union.CascadedPolygonUnionTester;
import test.jts.junit.GeometryUtils;

public class CascadedPolygonUnionFileTest
extends TestCase {
    private static CascadedPolygonUnionTester tester = new CascadedPolygonUnionTester();

    public CascadedPolygonUnionFileTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(CascadedPolygonUnionFileTest.class);
    }

    public void testAfrica2() throws Exception {
        this.runTestResource("../../../../../data/africa.wkt", 0.999999);
    }

    public void XtestEurope() throws Exception {
        this.runTestResource("../../../../../data/europe.wkt", 0.999999);
    }

    private void runTest(String filename, double minimumMeasure) throws IOException, ParseException {
        Collection geoms = GeometryUtils.readWKTFile(filename);
        CascadedPolygonUnionFileTest.assertTrue((boolean)tester.test(geoms, minimumMeasure));
    }

    private void runTestResource(String resource, double minimumMeasure) throws IOException, ParseException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        if (is == null) {
            return;
        }
        Collection geoms = GeometryUtils.readWKTFile(new InputStreamReader(is));
        CascadedPolygonUnionFileTest.assertTrue((boolean)tester.test(geoms, minimumMeasure));
    }
}

