/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.union.CascadedPolygonUnionTester;
import test.jts.junit.GeometryUtils;

public class CascadedPolygonUnionTest
extends TestCase {
    GeometryFactory geomFact = new GeometryFactory();
    private static CascadedPolygonUnionTester tester = new CascadedPolygonUnionTester();

    public CascadedPolygonUnionTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(CascadedPolygonUnionTest.class);
    }

    public void testBoxes() throws Exception {
        this.runTest(GeometryUtils.readWKT(new String[]{"POLYGON ((80 260, 200 260, 200 30, 80 30, 80 260))", "POLYGON ((30 180, 300 180, 300 110, 30 110, 30 180))", "POLYGON ((30 280, 30 150, 140 150, 140 280, 30 280))"}), 0.999999);
    }

    public void testDiscs1() throws Exception {
        Collection geoms = this.createDiscs(5, 0.7);
        this.runTest(geoms, 0.999999);
    }

    public void testDiscs2() throws Exception {
        Collection geoms = this.createDiscs(5, 0.55);
        this.runTest(geoms, 0.999999);
    }

    private void runTest(Collection geoms, double minimumMeasure) {
        CascadedPolygonUnionTest.assertTrue((boolean)tester.test(geoms, minimumMeasure));
    }

    private Collection createDiscs(int num, double radius) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (int i = 0; i < num; ++i) {
            for (int j = 0; j < num; ++j) {
                Coordinate pt = new Coordinate((double)i, (double)j);
                Point ptGeom = this.geomFact.createPoint(pt);
                Geometry disc = ptGeom.buffer(radius);
                geoms.add(disc);
            }
        }
        return geoms;
    }
}

