/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import test.jts.junit.GeometryUtils;

public class UnaryUnionTest
extends TestCase {
    GeometryFactory geomFact = new GeometryFactory();

    public UnaryUnionTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(UnaryUnionTest.class);
    }

    public void testEmptyCollection() throws Exception {
        this.doTest(new String[0], "GEOMETRYCOLLECTION EMPTY");
    }

    public void testPoints() throws Exception {
        this.doTest(new String[]{"POINT (1 1)", "POINT (2 2)"}, "MULTIPOINT ((1 1), (2 2))");
    }

    public void testLineNoding() throws Exception {
        this.doTest(new String[]{"LINESTRING (0 0, 10 0, 5 -5, 5 5)"}, "MULTILINESTRING ((0 0, 5 0), (5 0, 10 0, 5 -5, 5 0), (5 0, 5 5))");
    }

    public void testAll() throws Exception {
        this.doTest(new String[]{"GEOMETRYCOLLECTION (POLYGON ((0 0, 0 90, 90 90, 90 0, 0 0)),   POLYGON ((120 0, 120 90, 210 90, 210 0, 120 0)),  LINESTRING (40 50, 40 140),  LINESTRING (160 50, 160 140),  POINT (60 50),  POINT (60 140),  POINT (40 140))"}, "GEOMETRYCOLLECTION (POINT (60 140),   LINESTRING (40 90, 40 140), LINESTRING (160 90, 160 140), POLYGON ((0 0, 0 90, 40 90, 90 90, 90 0, 0 0)), POLYGON ((120 0, 120 90, 160 90, 210 90, 210 0, 120 0)))");
    }

    private void doTest(String[] inputWKT, String expectedWKT) throws ParseException {
        List geoms = GeometryUtils.readWKT(inputWKT);
        Geometry result = geoms.size() == 0 ? UnaryUnionOp.union((Collection)geoms, (GeometryFactory)this.geomFact) : UnaryUnionOp.union((Collection)geoms);
        UnaryUnionTest.assertTrue((boolean)GeometryUtils.isEqual(GeometryUtils.readWKT(expectedWKT), result));
    }
}

