/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.operation.valid.TopologyValidationError;

public class IsValidTest
extends TestCase {
    private PrecisionModel precisionModel = new PrecisionModel();
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        TestRunner.run(IsValidTest.class);
    }

    public IsValidTest(String name) {
        super(name);
    }

    public void testInvalidCoordinate() throws Exception {
        Coordinate badCoord = new Coordinate(1.0, Double.NaN);
        Coordinate[] pts = new Coordinate[]{new Coordinate(0.0, 0.0), badCoord};
        LineString line = this.geometryFactory.createLineString(pts);
        IsValidOp isValidOp = new IsValidOp((Geometry)line);
        boolean valid = isValidOp.isValid();
        TopologyValidationError err = isValidOp.getValidationError();
        Coordinate errCoord = err.getCoordinate();
        IsValidTest.assertEquals((int)10, (int)err.getErrorType());
        IsValidTest.assertTrue((boolean)Double.isNaN(errCoord.y));
        IsValidTest.assertEquals((boolean)false, (boolean)valid);
    }
}

