/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.util.Assert;

public class SimpleNestedRingTester {
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private Coordinate nestedPt;

    public SimpleNestedRingTester(GeometryGraph graph) {
        this.graph = graph;
    }

    public void add(LinearRing ring) {
        this.rings.add(ring);
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNonNested() {
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing innerRing = (LinearRing)this.rings.get(i);
            Coordinate[] innerRingPts = innerRing.getCoordinates();
            for (int j = 0; j < this.rings.size(); ++j) {
                LinearRing searchRing = (LinearRing)this.rings.get(j);
                Coordinate[] searchRingPts = searchRing.getCoordinates();
                if (innerRing == searchRing || !innerRing.getEnvelopeInternal().intersects(searchRing.getEnvelopeInternal())) continue;
                Coordinate innerRingPt = IsValidOp.findPtNotNode((Coordinate[])innerRingPts, (LinearRing)searchRing, (GeometryGraph)this.graph);
                Assert.isTrue((innerRingPt != null ? 1 : 0) != 0, (String)"Unable to find a ring point not a node of the search ring");
                boolean isInside = PointLocation.isInRing((Coordinate)innerRingPt, (Coordinate[])searchRingPts);
                if (!isInside) continue;
                this.nestedPt = innerRingPt;
                return false;
            }
        }
        return true;
    }
}

