/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.valid.IsValidOp;

public class ValidSelfTouchingRingFormingHoleTest
extends TestCase {
    private static WKTReader rdr = new WKTReader();

    public ValidSelfTouchingRingFormingHoleTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(ValidSelfTouchingRingFormingHoleTest.class);
    }

    public void testShellAndHoleSelfTouch() {
        String wkt = "POLYGON ((0 0, 0 340, 320 340, 320 0, 120 0, 180 100, 60 100, 120 0, 0 0),   (80 300, 80 180, 200 180, 200 240, 280 200, 280 280, 200 240, 200 300, 80 300))";
        this.checkIsValidSTR(wkt, true);
        this.checkIsValidDefault(wkt, false);
    }

    public void testShellHoleAndHoleHoleTouch() {
        String wkt = "POLYGON ((0 0, 0 340, 320 340, 320 0, 120 0, 0 0),   (120 0, 180 100, 60 100, 120 0),   (80 300, 80 180, 200 180, 200 240, 200 300, 80 300),  (200 240, 280 200, 280 280, 200 240))";
        this.checkIsValidSTR(wkt, true);
        this.checkIsValidDefault(wkt, true);
    }

    public void testShellSelfTouchHoleOverlappingHole() {
        String wkt = "POLYGON ((0 0, 220 0, 220 200, 120 200, 140 100, 80 100, 120 200, 0 200, 0 0),   (200 80, 20 80, 120 200, 200 80))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidDefault(wkt, false);
    }

    public void testDisconnectedInteriorShellSelfTouchAtNonVertex() {
        String wkt = "POLYGON ((40 180, 40 60, 240 60, 240 180, 140 60, 40 180))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidDefault(wkt, false);
    }

    public void testDisconnectedInteriorShellSelfTouchAtVertex() {
        String wkt = "POLYGON ((20 20, 20 100, 140 100, 140 180, 260 180, 260 100, 140 100, 140 20, 20 20))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidDefault(wkt, false);
    }

    public void testShellCross() {
        String wkt = "POLYGON ((20 20, 120 20, 120 220, 240 220, 240 120, 20 120, 20 20))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidDefault(wkt, false);
    }

    public void testShellCrossAndSTR() {
        String wkt = "POLYGON ((20 20, 120 20, 120 220, 180 220, 140 160, 200 160, 180 220, 240 220, 240 120, 20 120,  20 20))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidDefault(wkt, false);
    }

    private void checkIsValidDefault(String wkt, boolean expected) {
        Geometry geom = this.fromWKT(wkt);
        IsValidOp validator = new IsValidOp(geom);
        boolean isValid = validator.isValid();
        ValidSelfTouchingRingFormingHoleTest.assertTrue((isValid == expected ? 1 : 0) != 0);
    }

    private void checkIsValidSTR(String wkt, boolean expected) {
        Geometry geom = this.fromWKT(wkt);
        IsValidOp validator = new IsValidOp(geom);
        validator.setSelfTouchingRingFormingHoleValid(true);
        boolean isValid = validator.isValid();
        ValidSelfTouchingRingFormingHoleTest.assertTrue((isValid == expected ? 1 : 0) != 0);
    }

    Geometry fromWKT(String wkt) {
        Geometry geom = null;
        try {
            geom = rdr.read(wkt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return geom;
    }
}

