/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.precision.GeometryPrecisionReducer;

public class GeometryPrecisionReducerTest
extends TestCase {
    private PrecisionModel pmFloat = new PrecisionModel();
    private PrecisionModel pmFixed1 = new PrecisionModel(1.0);
    private GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(this.pmFixed1);
    private GeometryPrecisionReducer reducerKeepCollapse = new GeometryPrecisionReducer(this.pmFixed1);
    private GeometryFactory gfFloat = new GeometryFactory(this.pmFloat, 0);
    WKTReader reader = new WKTReader(this.gfFloat);

    public static void main(String[] args) {
        TestRunner.run(GeometryPrecisionReducerTest.class);
    }

    public GeometryPrecisionReducerTest(String name) {
        super(name);
        this.reducerKeepCollapse.setRemoveCollapsedComponents(false);
    }

    public void testSquare() throws Exception {
        Geometry g = this.reader.read("POLYGON (( 0 0, 0 1.4, 1.4 1.4, 1.4 0, 0 0 ))");
        Geometry g2 = this.reader.read("POLYGON (( 0 0, 0 1, 1 1, 1 0, 0 0 ))");
        Geometry gReduce = this.reducer.reduce(g);
        this.assertEqualsExactAndHasSameFactory(gReduce, g2);
    }

    public void testTinySquareCollapse() throws Exception {
        Geometry g = this.reader.read("POLYGON (( 0 0, 0 .4, .4 .4, .4 0, 0 0 ))");
        Geometry g2 = this.reader.read("POLYGON EMPTY");
        Geometry gReduce = this.reducer.reduce(g);
        this.assertEqualsExactAndHasSameFactory(gReduce, g2);
    }

    public void testSquareCollapse() throws Exception {
        Geometry g = this.reader.read("POLYGON (( 0 0, 0 1.4, .4 .4, .4 0, 0 0 ))");
        Geometry g2 = this.reader.read("POLYGON EMPTY");
        Geometry gReduce = this.reducer.reduce(g);
        this.assertEqualsExactAndHasSameFactory(gReduce, g2);
    }

    public void testSquareKeepCollapse() throws Exception {
        Geometry g = this.reader.read("POLYGON (( 0 0, 0 1.4, .4 .4, .4 0, 0 0 ))");
        Geometry g2 = this.reader.read("POLYGON EMPTY");
        Geometry gReduce = this.reducerKeepCollapse.reduce(g);
        this.assertEqualsExactAndHasSameFactory(gReduce, g2);
    }

    public void testLine() throws Exception {
        Geometry g = this.reader.read("LINESTRING ( 0 0, 0 1.4 )");
        Geometry g2 = this.reader.read("LINESTRING (0 0, 0 1)");
        Geometry gReduce = this.reducer.reduce(g);
        this.assertEqualsExactAndHasSameFactory(gReduce, g2);
    }

    public void testLineRemoveCollapse() throws Exception {
        Geometry g = this.reader.read("LINESTRING ( 0 0, 0 .4 )");
        Geometry g2 = this.reader.read("LINESTRING EMPTY");
        Geometry gReduce = this.reducer.reduce(g);
        this.assertEqualsExactAndHasSameFactory(gReduce, g2);
    }

    public void testLineKeepCollapse() throws Exception {
        Geometry g = this.reader.read("LINESTRING ( 0 0, 0 .4 )");
        Geometry g2 = this.reader.read("LINESTRING ( 0 0, 0 0 )");
        Geometry gReduce = this.reducerKeepCollapse.reduce(g);
        this.assertEqualsExactAndHasSameFactory(gReduce, g2);
    }

    public void testPolgonWithCollapsedLine() throws Exception {
        Geometry g = this.reader.read("POLYGON ((10 10, 100 100, 200 10.1, 300 10, 10 10))");
        Geometry g2 = this.reader.read("POLYGON ((10 10, 100 100, 200 10, 10 10))");
        Geometry gReduce = this.reducer.reduce(g);
        this.assertEqualsExactAndHasSameFactory(gReduce, g2);
    }

    public void testPolgonWithCollapsedLinePointwise() throws Exception {
        Geometry g = this.reader.read("POLYGON ((10 10, 100 100, 200 10.1, 300 10, 10 10))");
        Geometry g2 = this.reader.read("POLYGON ((10 10, 100 100, 200 10,   300 10, 10 10))");
        Geometry gReduce = GeometryPrecisionReducer.reducePointwise((Geometry)g, (PrecisionModel)this.pmFixed1);
        this.assertEqualsExactAndHasSameFactory(gReduce, g2);
    }

    public void testPolgonWithCollapsedPoint() throws Exception {
        Geometry g = this.reader.read("POLYGON ((10 10, 100 100, 200 10.1, 300 100, 400 10, 10 10))");
        Geometry g2 = this.reader.read("MULTIPOLYGON (((10 10, 100 100, 200 10, 10 10)), ((200 10, 300 100, 400 10, 200 10)))");
        Geometry gReduce = this.reducer.reduce(g);
        this.assertEqualsExactAndHasSameFactory(gReduce, g2);
    }

    public void testPolgonWithCollapsedPointPointwise() throws Exception {
        Geometry g = this.reader.read("POLYGON ((10 10, 100 100, 200 10.1, 300 100, 400 10, 10 10))");
        Geometry g2 = this.reader.read("POLYGON ((10 10, 100 100, 200 10,   300 100, 400 10, 10 10))");
        Geometry gReduce = GeometryPrecisionReducer.reducePointwise((Geometry)g, (PrecisionModel)this.pmFixed1);
        this.assertEqualsExactAndHasSameFactory(gReduce, g2);
    }

    private void assertEqualsExactAndHasSameFactory(Geometry a, Geometry b) {
        GeometryPrecisionReducerTest.assertTrue((boolean)a.equalsExact(b));
        GeometryPrecisionReducerTest.assertTrue((a.getFactory() == b.getFactory() ? 1 : 0) != 0);
    }
}

