/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.precision.MinimumClearance;

public class MinimumClearanceTest
extends TestCase {
    private GeometryFactory geomFact = new GeometryFactory();
    private WKTReader reader = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(MinimumClearanceTest.class);
    }

    public MinimumClearanceTest(String name) {
        super(name);
    }

    public void test2IdenticalPoints() throws ParseException {
        this.runTest("MULTIPOINT ((100 100), (100 100))", Double.MAX_VALUE);
    }

    public void test3Points() throws ParseException {
        this.runTest("MULTIPOINT ((100 100), (10 100), (30 100))", 20.0);
    }

    public void testTriangle() throws ParseException {
        this.runTest("POLYGON ((100 100, 300 100, 200 200, 100 100))", 100.0);
    }

    private void runTest(String wkt, double expectedValue) throws ParseException {
        Geometry g = this.reader.read(wkt);
        double rp = MinimumClearance.getDistance((Geometry)g);
        MinimumClearanceTest.assertEquals((Object)expectedValue, (Object)rp);
    }
}

