/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.precision.SimpleGeometryPrecisionReducer;

public class SimpleGeometryPrecisionReducerTest
extends TestCase {
    private PrecisionModel pmFloat = new PrecisionModel();
    private PrecisionModel pmFixed1 = new PrecisionModel(1.0);
    private SimpleGeometryPrecisionReducer reducer = new SimpleGeometryPrecisionReducer(this.pmFixed1);
    private SimpleGeometryPrecisionReducer reducerKeepCollapse = new SimpleGeometryPrecisionReducer(this.pmFixed1);
    private GeometryFactory gfFloat = new GeometryFactory(this.pmFloat, 0);
    WKTReader reader = new WKTReader(this.gfFloat);

    public static void main(String[] args) {
        TestRunner.run(SimpleGeometryPrecisionReducerTest.class);
    }

    public SimpleGeometryPrecisionReducerTest(String name) {
        super(name);
        this.reducerKeepCollapse.setRemoveCollapsedComponents(false);
    }

    public void testSquare() throws Exception {
        Geometry g = this.reader.read("POLYGON (( 0 0, 0 1.4, 1.4 1.4, 1.4 0, 0 0 ))");
        Geometry g2 = this.reader.read("POLYGON (( 0 0, 0 1, 1 1, 1 0, 0 0 ))");
        Geometry gReduce = this.reducer.reduce(g);
        SimpleGeometryPrecisionReducerTest.assertTrue((boolean)gReduce.equalsExact(g2));
    }

    public void testTinySquareCollapse() throws Exception {
        Geometry g = this.reader.read("POLYGON (( 0 0, 0 .4, .4 .4, .4 0, 0 0 ))");
        Geometry g2 = this.reader.read("POLYGON EMPTY");
        Geometry gReduce = this.reducer.reduce(g);
        SimpleGeometryPrecisionReducerTest.assertTrue((boolean)gReduce.equalsExact(g2));
    }

    public void testSquareCollapse() throws Exception {
        Geometry g = this.reader.read("POLYGON (( 0 0, 0 1.4, .4 .4, .4 0, 0 0 ))");
        Geometry g2 = this.reader.read("POLYGON EMPTY");
        Geometry gReduce = this.reducer.reduce(g);
        SimpleGeometryPrecisionReducerTest.assertTrue((boolean)gReduce.equalsExact(g2));
    }

    public void testSquareKeepCollapse() throws Exception {
        Geometry g = this.reader.read("POLYGON (( 0 0, 0 1.4, .4 .4, .4 0, 0 0 ))");
        Geometry g2 = this.reader.read("POLYGON (( 0 0, 0 1, 0 0, 0 0, 0 0 ))");
        Geometry gReduce = this.reducerKeepCollapse.reduce(g);
        SimpleGeometryPrecisionReducerTest.assertTrue((boolean)gReduce.equalsExact(g2));
    }

    public void testLine() throws Exception {
        Geometry g = this.reader.read("LINESTRING ( 0 0, 0 1.4 )");
        Geometry g2 = this.reader.read("LINESTRING (0 0, 0 1)");
        Geometry gReduce = this.reducer.reduce(g);
        SimpleGeometryPrecisionReducerTest.assertTrue((boolean)gReduce.equalsExact(g2));
    }

    public void testLineRemoveCollapse() throws Exception {
        Geometry g = this.reader.read("LINESTRING ( 0 0, 0 .4 )");
        Geometry g2 = this.reader.read("LINESTRING EMPTY");
        Geometry gReduce = this.reducer.reduce(g);
        SimpleGeometryPrecisionReducerTest.assertTrue((boolean)gReduce.equalsExact(g2));
    }

    public void testLineKeepCollapse() throws Exception {
        Geometry g = this.reader.read("LINESTRING ( 0 0, 0 .4 )");
        Geometry g2 = this.reader.read("LINESTRING ( 0 0, 0 0 )");
        Geometry gReduce = this.reducerKeepCollapse.reduce(g);
        SimpleGeometryPrecisionReducerTest.assertTrue((boolean)gReduce.equalsExact(g2));
    }
}

