/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import junit.framework.Assert;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.simplify.SameStructureTester;

public class GeometryOperationValidator {
    private static WKTReader rdr = new WKTReader();
    private Geometry[] ioGeometry;
    private boolean expectedSameStructure = false;
    private String wktExpected = null;

    public GeometryOperationValidator(Geometry[] ioGeometry) {
        this.ioGeometry = ioGeometry;
    }

    public GeometryOperationValidator setExpectedResult(String wktExpected) {
        this.wktExpected = wktExpected;
        return this;
    }

    public GeometryOperationValidator setExpectedSameStructure() {
        this.expectedSameStructure = true;
        return this;
    }

    public boolean isAllTestsPassed() {
        try {
            this.test();
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public void test() throws Exception {
        this.testSameStructure();
        this.testValid();
        this.testExpectedResult();
    }

    public GeometryOperationValidator testSameStructure() throws Exception {
        if (!this.expectedSameStructure) {
            return this;
        }
        Assert.assertTrue((String)"simplified geometry has different structure than input", (boolean)SameStructureTester.isSameStructure(this.ioGeometry[0], this.ioGeometry[1]));
        return this;
    }

    public GeometryOperationValidator testValid() throws Exception {
        Assert.assertTrue((String)"simplified geometry is not valid", (boolean)this.ioGeometry[1].isValid());
        return this;
    }

    public GeometryOperationValidator testEmpty(boolean isEmpty) throws Exception {
        String failureCondition = isEmpty ? "not empty" : "empty";
        Assert.assertTrue((String)("simplified geometry is " + failureCondition), (this.ioGeometry[1].isEmpty() == isEmpty ? 1 : 0) != 0);
        return this;
    }

    private void testExpectedResult() throws Exception {
        if (this.wktExpected == null) {
            return;
        }
        Geometry expectedGeom = rdr.read(this.wktExpected);
        boolean isEqual = expectedGeom.equalsExact(this.ioGeometry[1]);
        if (!isEqual) {
            System.out.println("Result not expected: " + this.ioGeometry[1]);
        }
        Assert.assertTrue((String)"Expected result not found", (boolean)isEqual);
    }
}

