/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;

public class VoronoiTest
extends TestCase {
    private WKTReader reader = new WKTReader();
    static final double COMPARISON_TOLERANCE = 1.0E-7;

    public static void main(String[] args) {
        TestRunner.run(VoronoiTest.class);
    }

    public VoronoiTest(String name) {
        super(name);
    }

    public void testSimple() throws ParseException {
        String wkt = "MULTIPOINT ((10 10), (20 70), (60 30), (80 70))";
        String expected = "GEOMETRYCOLLECTION (POLYGON ((-1162.076359832636 462.66344142259413, 50 419.375, 50 60, 27.857142857142854 37.857142857142854, -867 187, -1162.076359832636 462.66344142259413)), POLYGON ((-867 187, 27.857142857142854 37.857142857142854, 245 -505, 45 -725, -867 187)), POLYGON ((27.857142857142854 37.857142857142854, 50 60, 556.6666666666666 -193.33333333333331, 245 -505, 27.857142857142854 37.857142857142854)), POLYGON ((50 60, 50 419.375, 1289.1616314199396 481.3330815709969, 556.6666666666666 -193.33333333333331, 50 60)))";
        this.runVoronoi(wkt, true, expected);
    }

    void runVoronoi(String sitesWKT, boolean computeTriangles, String expectedWKT) throws ParseException {
        Geometry sites = this.reader.read(sitesWKT);
        DelaunayTriangulationBuilder builder = new DelaunayTriangulationBuilder();
        builder.setSites(sites);
        QuadEdgeSubdivision subdiv = builder.getSubdivision();
        GeometryFactory geomFact = new GeometryFactory();
        Geometry result = null;
        if (computeTriangles) {
            result = subdiv.getVoronoiDiagram(geomFact);
        }
        Geometry expectedEdges = this.reader.read(expectedWKT);
        result.normalize();
        expectedEdges.normalize();
        VoronoiTest.assertTrue((boolean)expectedEdges.equalsExact(result, 1.0E-7));
    }
}

