/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.util.PriorityQueue;

public class PriorityQueueTest
extends TestCase {
    public PriorityQueueTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(PriorityQueueTest.class);
    }

    public void testOrder1() throws Exception {
        PriorityQueue q = new PriorityQueue();
        q.add((Comparable)new Integer(1));
        q.add((Comparable)new Integer(10));
        q.add((Comparable)new Integer(5));
        q.add((Comparable)new Integer(8));
        q.add((Comparable)new Integer(-1));
        this.checkOrder(q);
    }

    public void testOrderRandom1() throws Exception {
        PriorityQueue q = new PriorityQueue();
        this.addRandomItems(q, 100);
        this.checkOrder(q);
    }

    private void addRandomItems(PriorityQueue q, int num) {
        for (int i = 0; i < num; ++i) {
            q.add((Comparable)new Integer((int)((double)num * Math.random())));
        }
    }

    private void checkOrder(PriorityQueue q) {
        Comparable curr = null;
        while (!q.isEmpty()) {
            Comparable next = (Comparable)q.poll();
            if (curr == null) {
                curr = next;
                continue;
            }
            PriorityQueueTest.assertTrue((next.compareTo(curr) >= 0 ? 1 : 0) != 0);
        }
    }
}

