/*
 * Decompiled with CFR 0.152.
 */
package test.jts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GeometryTestCase
extends TestCase {
    GeometryFactory geomFactory = new GeometryFactory();
    WKTReader reader = new WKTReader(this.geomFactory);

    public GeometryTestCase(String name) {
        super(name);
    }

    protected void checkEqual(Geometry expected, Geometry actual) {
        Geometry expectedNorm;
        Geometry actualNorm = actual.norm();
        boolean equal = actualNorm.equalsExact(expectedNorm = expected.norm());
        if (!equal) {
            System.out.println("FAIL - Expected = " + expectedNorm + " actual = " + actualNorm);
        }
        GeometryTestCase.assertTrue((boolean)equal);
    }

    protected void checkEqual(Collection expected, Collection actual) {
        this.checkEqual((Geometry)this.toGeometryCollection(expected), (Geometry)this.toGeometryCollection(actual));
    }

    GeometryCollection toGeometryCollection(Collection geoms) {
        return this.geomFactory.createGeometryCollection(GeometryFactory.toGeometryArray((Collection)geoms));
    }

    protected Geometry read(GeometryFactory geomFactory, String wkt) {
        WKTReader reader = new WKTReader(geomFactory);
        try {
            return reader.read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected Geometry read(String wkt) {
        try {
            return this.reader.read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected List readList(String[] wkt) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = 0; i < wkt.length; ++i) {
            geometries.add(this.read(wkt[i]));
        }
        return geometries;
    }
}

