/*
 * Decompiled with CFR 0.152.
 */
package test.jts.index;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.index.bintree.Bintree;
import org.locationtech.jts.index.bintree.Interval;
import org.locationtech.jts.util.Stopwatch;
import test.jts.index.IntervalList;

public class BinTreeCorrectTest {
    static final int NUM_ITEMS = 20000;
    static final double MIN_EXTENT = -1000.0;
    static final double MAX_EXTENT = 1000.0;
    IntervalList intervalList = new IntervalList();
    Bintree btree = new Bintree();

    public static void main(String[] args) throws Exception {
        BinTreeCorrectTest test = new BinTreeCorrectTest();
        test.run();
    }

    public void run() {
        this.fill();
        System.out.println("depth = " + this.btree.depth() + "  size = " + this.btree.size());
        this.runQueries();
    }

    void fill() {
        this.createGrid(20000);
    }

    void createGrid(int nGridCells) {
        int gridSize = (int)Math.sqrt(nGridCells);
        double extent = 2000.0;
        double gridInc = extent / (double)(++gridSize);
        double cellSize = 2.0 * gridInc;
        for (int i = 0; i < gridSize; ++i) {
            double x = -1000.0 + gridInc * (double)i;
            Interval interval = new Interval(x, x + cellSize);
            this.btree.insert(interval, (Object)interval);
            this.intervalList.add(interval);
        }
    }

    void runQueries() {
        int nGridCells = 100;
        int cellSize = (int)Math.sqrt(20000.0);
        double extent = 2000.0;
        double queryCellSize = 2.0 * extent / (double)cellSize;
        this.queryGrid(nGridCells, queryCellSize);
    }

    void queryGrid(int nGridCells, double cellSize) {
        Stopwatch sw = new Stopwatch();
        sw.start();
        int gridSize = (int)Math.sqrt(nGridCells);
        double extent = 2000.0;
        double gridInc = extent / (double)(++gridSize);
        for (int i = 0; i < gridSize; ++i) {
            double x = -1000.0 + gridInc * (double)i;
            Interval interval = new Interval(x, x + cellSize);
            this.queryTest(interval);
        }
        System.out.println("Time = " + sw.getTimeString());
    }

    void queryTime(Interval interval) {
        List eList = this.intervalList.query(interval);
    }

    void queryTest(Interval interval) {
        List candidateList = this.btree.query(interval);
        List finalList = this.getOverlapping(candidateList, interval);
        List eList = this.intervalList.query(interval);
        System.out.println(finalList.size());
        if (finalList.size() != eList.size()) {
            throw new RuntimeException("queries do not match");
        }
    }

    private List getOverlapping(List items, Interval searchInterval) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        for (int i = 0; i < items.size(); ++i) {
            Interval interval = (Interval)items.get(i);
            if (!interval.overlaps(searchInterval)) continue;
            result.add(interval);
        }
        return result;
    }
}

