/*
 * Decompiled with CFR 0.152.
 */
package test.jts.index;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.locationtech.jts.util.Stopwatch;
import test.jts.index.Index;

public class IndexTester {
    static final int NUM_ITEMS = 2000;
    static final double EXTENT_MIN = -1000.0;
    static final double EXTENT_MAX = 1000.0;
    Index index;
    private static List victoriaItems = null;

    public IndexTester(Index index) {
        this.index = index;
    }

    public IndexResult testAll(List items) {
        IndexResult result = new IndexResult(this.index.toString());
        System.out.print(this.index.toString() + "           ");
        System.gc();
        Stopwatch sw = new Stopwatch();
        sw.start();
        this.loadGrid(items);
        String loadTime = sw.getTimeString();
        result.loadMilliseconds = sw.getTime();
        System.gc();
        sw.start();
        this.runSelfQuery(items);
        String queryTime = sw.getTimeString();
        result.queryMilliseconds = sw.getTime();
        System.out.println("  Load Time = " + loadTime + "  Query Time = " + queryTime);
        return result;
    }

    public static List createGridItems(int nGridCells) {
        double gridInc;
        ArrayList<Envelope> items = new ArrayList<Envelope>();
        int gridSize = (int)Math.sqrt(nGridCells);
        double extent = 2000.0;
        double cellSize = gridInc = extent / (double)(++gridSize);
        for (int i = 0; i < gridSize; ++i) {
            for (int j = 0; j < gridSize; ++j) {
                double x = -1000.0 + gridInc * (double)i;
                double y = -1000.0 + gridInc * (double)j;
                Envelope env = new Envelope(x, x + cellSize, y, y + cellSize);
                items.add(env);
            }
        }
        return items;
    }

    void loadGrid(List items) {
        for (Envelope item : items) {
            this.index.insert(item, item);
        }
        this.index.finishInserting();
    }

    void runSelfQuery(List items) {
        double querySize = 0.0;
        for (int i = 0; i < items.size(); ++i) {
            Envelope env = (Envelope)items.get(i);
            List list = this.index.query(env);
            Assert.isTrue((!list.isEmpty() ? 1 : 0) != 0);
            querySize += (double)list.size();
        }
        System.out.println("Avg query size = " + querySize / (double)items.size());
    }

    void runGridQuery() {
        int nGridCells = 100;
        int cellSize = (int)Math.sqrt(2000.0);
        double extent = 2000.0;
        double queryCellSize = 2.0 * extent / (double)cellSize;
        this.queryGrid(nGridCells, queryCellSize);
    }

    void queryGrid(int nGridCells, double cellSize) {
        int gridSize = (int)Math.sqrt(nGridCells);
        double extent = 2000.0;
        double gridInc = extent / (double)(++gridSize);
        for (int i = 0; i < gridSize; ++i) {
            for (int j = 0; j < gridSize; ++j) {
                double x = -1000.0 + gridInc * (double)i;
                double y = -1000.0 + gridInc * (double)j;
                Envelope env = new Envelope(x, x + cellSize, y, y + cellSize);
                this.index.query(env);
            }
        }
    }

    public static class IndexResult {
        public String indexName;
        public long loadMilliseconds;
        public long queryMilliseconds;

        public IndexResult(String indexName) {
            this.indexName = indexName;
        }
    }
}

