/*
 * Decompiled with CFR 0.152.
 */
package test.jts.index;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.index.strtree.STRtree;
import test.jts.index.EnvelopeList;
import test.jts.index.Index;
import test.jts.index.IndexTester;

public class TreeTimeTest {
    public static final int NUM_ITEMS = 10000;

    public static void main(String[] args) throws Exception {
        int n = 10000;
        TreeTimeTest test = new TreeTimeTest();
        List items = IndexTester.createGridItems(n);
        System.out.println("----------------------------------------------");
        System.out.println("Dummy run to ensure classes are loaded before real run");
        System.out.println("----------------------------------------------");
        test.run(items);
        System.out.println("----------------------------------------------");
        System.out.println("Real run");
        System.out.println("----------------------------------------------");
        test.run(items);
    }

    public List run(List items) throws Exception {
        ArrayList<IndexTester.IndexResult> indexResults = new ArrayList<IndexTester.IndexResult>();
        System.out.println("# items = " + items.size());
        indexResults.add(this.run(new QuadtreeIndex(), items));
        indexResults.add(this.run(new STRtreeIndex(10), items));
        return indexResults;
    }

    public IndexTester.IndexResult run(Index index, List items) throws Exception {
        return new IndexTester(index).testAll(items);
    }

    class EnvelopeListIndex
    implements Index {
        EnvelopeList index = new EnvelopeList();

        EnvelopeListIndex() {
        }

        public String toString() {
            return "Env";
        }

        @Override
        public void insert(Envelope itemEnv, Object item) {
            this.index.add(itemEnv);
        }

        @Override
        public List query(Envelope searchEnv) {
            return this.index.query(searchEnv);
        }

        @Override
        public void finishInserting() {
        }
    }

    class QuadtreeIndex
    implements Index {
        Quadtree index = new Quadtree();

        QuadtreeIndex() {
        }

        public String toString() {
            return "Quad";
        }

        @Override
        public void insert(Envelope itemEnv, Object item) {
            this.index.insert(itemEnv, item);
        }

        @Override
        public List query(Envelope searchEnv) {
            return this.index.query(searchEnv);
        }

        @Override
        public void finishInserting() {
        }
    }

    class STRtreeIndex
    implements Index {
        STRtree index;

        public String toString() {
            return "STR[M=" + this.index.getNodeCapacity() + "]";
        }

        public STRtreeIndex(int nodeCapacity) {
            this.index = new STRtree(nodeCapacity);
        }

        @Override
        public void insert(Envelope itemEnv, Object item) {
            this.index.insert(itemEnv, item);
        }

        @Override
        public List query(Envelope searchEnv) {
            return this.index.query(searchEnv);
        }

        @Override
        public void finishInserting() {
            this.index.build();
        }
    }
}

