/*
 * Decompiled with CFR 0.152.
 */
package test.jts.junit;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTFileReader;
import org.locationtech.jts.io.WKTReader;

public class GeometryUtils {
    public static WKTReader reader = new WKTReader();

    public static List readWKT(String[] inputWKT) throws ParseException {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = 0; i < inputWKT.length; ++i) {
            geometries.add(reader.read(inputWKT[i]));
        }
        return geometries;
    }

    public static Geometry readWKT(String inputWKT) throws ParseException {
        return reader.read(inputWKT);
    }

    public static Collection readWKTFile(String filename) throws IOException, ParseException {
        WKTFileReader fileRdr = new WKTFileReader(filename, reader);
        List geoms = fileRdr.read();
        return geoms;
    }

    public static Collection readWKTFile(Reader rdr) throws IOException, ParseException {
        WKTFileReader fileRdr = new WKTFileReader(rdr, reader);
        List geoms = fileRdr.read();
        return geoms;
    }

    public static boolean isEqual(Geometry a, Geometry b) {
        Geometry a2 = GeometryUtils.normalize(a);
        Geometry b2 = GeometryUtils.normalize(b);
        return a2.equalsExact(b2);
    }

    public static Geometry normalize(Geometry g) {
        Geometry g2 = g.copy();
        g2.normalize();
        return g2;
    }
}

