/*
 * Decompiled with CFR 0.152.
 */
package test.jts.junit;

import java.util.ArrayList;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;

public class MiscellaneousTest
extends TestCase {
    PrecisionModel precisionModel = new PrecisionModel(1.0);
    GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        TestRunner.run(MiscellaneousTest.class);
    }

    public void testEnvelopeCloned() throws Exception {
        Geometry a = this.reader.read("LINESTRING(0 0, 10 10)");
        a.getEnvelopeInternal();
        Geometry b = a.copy();
        MiscellaneousTest.assertTrue((a.getEnvelopeInternal() != b.getEnvelopeInternal() ? 1 : 0) != 0);
    }

    public MiscellaneousTest(String name) {
        super(name);
    }

    public void testCreateEmptyGeometry() throws Exception {
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createPoint((Coordinate)null).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createLinearRing(new Coordinate[0]).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createLineString(new Coordinate[0]).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[0]), new LinearRing[0]).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createMultiPolygon(new Polygon[0]).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createMultiLineString(new LineString[0]).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createMultiPoint(new Point[0]).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createPoint((Coordinate)null).isSimple());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createLinearRing(new Coordinate[0]).isSimple());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createPoint((Coordinate)null).getBoundary().isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createLinearRing(new Coordinate[0]).getBoundary().isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createLineString(new Coordinate[0]).getBoundary().isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[0]), new LinearRing[0]).getBoundary().isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createMultiPolygon(new Polygon[0]).getBoundary().isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createMultiLineString(new LineString[0]).getBoundary().isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createMultiPoint(new Point[0]).getBoundary().isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createLinearRing((CoordinateSequence)null).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createLineString((Coordinate[])null).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createPolygon(null, null).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createMultiPolygon(null).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createMultiLineString(null).isEmpty());
        MiscellaneousTest.assertTrue((boolean)this.geometryFactory.createMultiPoint((Point[])null).isEmpty());
        MiscellaneousTest.assertEquals((int)-1, (int)this.geometryFactory.createPoint((Coordinate)null).getBoundaryDimension());
        MiscellaneousTest.assertEquals((int)-1, (int)this.geometryFactory.createLinearRing((CoordinateSequence)null).getBoundaryDimension());
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createLineString((Coordinate[])null).getBoundaryDimension());
        MiscellaneousTest.assertEquals((int)1, (int)this.geometryFactory.createPolygon(null, null).getBoundaryDimension());
        MiscellaneousTest.assertEquals((int)1, (int)this.geometryFactory.createMultiPolygon(null).getBoundaryDimension());
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createMultiLineString(null).getBoundaryDimension());
        MiscellaneousTest.assertEquals((int)-1, (int)this.geometryFactory.createMultiPoint((Point[])null).getBoundaryDimension());
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createPoint((Coordinate)null).getNumPoints());
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createLinearRing((CoordinateSequence)null).getNumPoints());
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createLineString((Coordinate[])null).getNumPoints());
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createPolygon(null, null).getNumPoints());
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createMultiPolygon(null).getNumPoints());
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createMultiLineString(null).getNumPoints());
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createMultiPoint((Point[])null).getNumPoints());
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createPoint((Coordinate)null).getCoordinates().length);
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createLinearRing((CoordinateSequence)null).getCoordinates().length);
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createLineString((Coordinate[])null).getCoordinates().length);
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createPolygon(null, null).getCoordinates().length);
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createMultiPolygon(null).getCoordinates().length);
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createMultiLineString(null).getCoordinates().length);
        MiscellaneousTest.assertEquals((int)0, (int)this.geometryFactory.createMultiPoint((Point[])null).getCoordinates().length);
    }

    public void testBoundaryOfEmptyGeometry() throws Exception {
        MiscellaneousTest.assertTrue((this.geometryFactory.createPoint((Coordinate)null).getBoundary().getClass() == GeometryCollection.class ? 1 : 0) != 0);
        MiscellaneousTest.assertTrue((this.geometryFactory.createLinearRing(new Coordinate[0]).getBoundary().getClass() == MultiPoint.class ? 1 : 0) != 0);
        MiscellaneousTest.assertTrue((this.geometryFactory.createLineString(new Coordinate[0]).getBoundary().getClass() == MultiPoint.class ? 1 : 0) != 0);
        MiscellaneousTest.assertTrue((this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[0]), new LinearRing[0]).getBoundary().getClass() == MultiLineString.class ? 1 : 0) != 0);
        MiscellaneousTest.assertTrue((this.geometryFactory.createMultiPolygon(new Polygon[0]).getBoundary().getClass() == MultiLineString.class ? 1 : 0) != 0);
        MiscellaneousTest.assertTrue((this.geometryFactory.createMultiLineString(new LineString[0]).getBoundary().getClass() == MultiPoint.class ? 1 : 0) != 0);
        MiscellaneousTest.assertTrue((this.geometryFactory.createMultiPoint(new Point[0]).getBoundary().getClass() == GeometryCollection.class ? 1 : 0) != 0);
        try {
            this.geometryFactory.createGeometryCollection(new Geometry[0]).getBoundary();
            MiscellaneousTest.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToPointArray() {
        ArrayList<Point> list = new ArrayList<Point>();
        list.add(this.geometryFactory.createPoint(new Coordinate(0.0, 0.0)));
        list.add(this.geometryFactory.createPoint(new Coordinate(10.0, 0.0)));
        list.add(this.geometryFactory.createPoint(new Coordinate(10.0, 10.0)));
        list.add(this.geometryFactory.createPoint(new Coordinate(0.0, 10.0)));
        list.add(this.geometryFactory.createPoint(new Coordinate(0.0, 0.0)));
        Point[] points = GeometryFactory.toPointArray(list);
        MiscellaneousTest.assertEquals((double)10.0, (double)points[1].getX(), (double)0.1);
        MiscellaneousTest.assertEquals((double)0.0, (double)points[1].getY(), (double)0.1);
    }

    public void testPolygonGetCoordinates() throws Exception {
        Polygon p = (Polygon)this.reader.read("POLYGON ( (0 0, 100 0, 100 100, 0 100, 0 0),           (20 20, 20 80, 80 80, 80 20, 20 20)) ");
        Coordinate[] coordinates = p.getCoordinates();
        MiscellaneousTest.assertEquals((int)10, (int)p.getNumPoints());
        MiscellaneousTest.assertEquals((int)10, (int)coordinates.length);
        MiscellaneousTest.assertEquals((Object)new Coordinate(0.0, 0.0), (Object)coordinates[0]);
        MiscellaneousTest.assertEquals((Object)new Coordinate(20.0, 20.0), (Object)coordinates[9]);
    }

    public void testEmptyPoint() throws Exception {
        Point p = this.geometryFactory.createPoint((Coordinate)null);
        MiscellaneousTest.assertEquals((int)0, (int)p.getDimension());
        MiscellaneousTest.assertEquals((Object)new Envelope(), (Object)p.getEnvelopeInternal());
        MiscellaneousTest.assertTrue((boolean)p.isSimple());
        try {
            p.getX();
            MiscellaneousTest.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            p.getY();
            MiscellaneousTest.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        MiscellaneousTest.assertEquals((Object)"POINT EMPTY", (Object)p.toString());
        MiscellaneousTest.assertEquals((Object)"POINT EMPTY", (Object)p.toText());
    }

    public void testEmptyLineString() throws Exception {
        LineString l = this.geometryFactory.createLineString((Coordinate[])null);
        MiscellaneousTest.assertEquals((int)1, (int)l.getDimension());
        MiscellaneousTest.assertEquals((Object)new Envelope(), (Object)l.getEnvelopeInternal());
        MiscellaneousTest.assertEquals(null, (Object)l.getStartPoint());
        MiscellaneousTest.assertEquals(null, (Object)l.getEndPoint());
        MiscellaneousTest.assertTrue((!l.isClosed() ? 1 : 0) != 0);
        MiscellaneousTest.assertTrue((!l.isRing() ? 1 : 0) != 0);
    }

    public void testEmptyLinearRing() throws Exception {
        LinearRing l = this.geometryFactory.createLinearRing((CoordinateSequence)null);
        MiscellaneousTest.assertEquals((int)1, (int)l.getDimension());
        MiscellaneousTest.assertEquals((Object)new Envelope(), (Object)l.getEnvelopeInternal());
        MiscellaneousTest.assertTrue((boolean)l.isSimple());
        MiscellaneousTest.assertEquals(null, (Object)l.getStartPoint());
        MiscellaneousTest.assertEquals(null, (Object)l.getEndPoint());
        MiscellaneousTest.assertTrue((boolean)l.isClosed());
        MiscellaneousTest.assertTrue((boolean)l.isRing());
    }

    public void testEmptyPolygon() throws Exception {
        Polygon p = this.geometryFactory.createPolygon(null, null);
        MiscellaneousTest.assertEquals((int)2, (int)p.getDimension());
        MiscellaneousTest.assertEquals((Object)new Envelope(), (Object)p.getEnvelopeInternal());
        MiscellaneousTest.assertTrue((boolean)p.isSimple());
    }

    public void testEmptyGeometryCollection() throws Exception {
        GeometryCollection g = this.geometryFactory.createGeometryCollection(null);
        MiscellaneousTest.assertEquals((int)-1, (int)g.getDimension());
        MiscellaneousTest.assertEquals((Object)new Envelope(), (Object)g.getEnvelopeInternal());
        MiscellaneousTest.assertTrue((boolean)g.isSimple());
    }

    public void testEmptyMultiPoint() throws Exception {
        MultiPoint g = this.geometryFactory.createMultiPoint((Point[])null);
        MiscellaneousTest.assertEquals((int)0, (int)g.getDimension());
        MiscellaneousTest.assertEquals((Object)new Envelope(), (Object)g.getEnvelopeInternal());
    }

    public void testEmptyMultiLineString() throws Exception {
        MultiLineString g = this.geometryFactory.createMultiLineString(null);
        MiscellaneousTest.assertEquals((int)1, (int)g.getDimension());
        MiscellaneousTest.assertEquals((Object)new Envelope(), (Object)g.getEnvelopeInternal());
        MiscellaneousTest.assertTrue((!g.isClosed() ? 1 : 0) != 0);
    }

    public void testEmptyMultiPolygon() throws Exception {
        MultiPolygon g = this.geometryFactory.createMultiPolygon(null);
        MiscellaneousTest.assertEquals((int)2, (int)g.getDimension());
        MiscellaneousTest.assertEquals((Object)new Envelope(), (Object)g.getEnvelopeInternal());
        MiscellaneousTest.assertTrue((boolean)g.isSimple());
    }

    public void testGetGeometryType() throws Exception {
        MultiPolygon g = this.geometryFactory.createMultiPolygon(null);
        MiscellaneousTest.assertEquals((Object)"MultiPolygon", (Object)g.getGeometryType());
    }

    public void testMultiPolygonIsSimple1() throws Exception {
        Geometry g = this.reader.read("MULTIPOLYGON (((10 10, 10 20, 20 20, 20 15, 10 10)), ((60 60, 70 70, 80 60, 60 60)))");
        MiscellaneousTest.assertTrue((boolean)g.isSimple());
    }

    public void testPointIsSimple() throws Exception {
        Geometry g = this.reader.read("POINT (10 10)");
        MiscellaneousTest.assertTrue((boolean)g.isSimple());
    }

    public void testPointGetBoundary() throws Exception {
        Geometry g = this.reader.read("POINT (10 10)");
        MiscellaneousTest.assertTrue((boolean)g.getBoundary().isEmpty());
    }

    public void testMultiPointGetBoundary() throws Exception {
        Geometry g = this.reader.read("MULTIPOINT(10 10, 20 20, 30 30)");
        MiscellaneousTest.assertTrue((boolean)g.getBoundary().isEmpty());
    }

    public void testLineStringGetBoundary1() throws Exception {
        LineString g = (LineString)this.reader.read("LINESTRING(10 10, 20 10, 15 20)");
        MiscellaneousTest.assertTrue((boolean)(g.getBoundary() instanceof MultiPoint));
        MultiPoint boundary = (MultiPoint)g.getBoundary();
        MiscellaneousTest.assertTrue((boolean)boundary.getGeometryN(0).equals((Geometry)g.getStartPoint()));
        MiscellaneousTest.assertTrue((boolean)boundary.getGeometryN(1).equals((Geometry)g.getEndPoint()));
    }

    public void testLineStringGetBoundary2() throws Exception {
        LineString g = (LineString)this.reader.read("LINESTRING(10 10, 20 10, 15 20, 10 10)");
        MiscellaneousTest.assertTrue((boolean)g.getBoundary().isEmpty());
    }

    public void testLinearRingIsSimple() throws Exception {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(10.0, 10.0, 0.0), new Coordinate(10.0, 20.0, 0.0), new Coordinate(20.0, 20.0, 0.0), new Coordinate(20.0, 15.0, 0.0), new Coordinate(10.0, 10.0, 0.0)};
        LinearRing linearRing = this.geometryFactory.createLinearRing(coordinates);
        MiscellaneousTest.assertTrue((boolean)linearRing.isSimple());
    }

    public void testPolygonIsSimple() throws Exception {
        Geometry g = this.reader.read("POLYGON((10 10, 10 20, 202 0, 20 15, 10 10))");
        MiscellaneousTest.assertTrue((boolean)g.isSimple());
    }

    public void testPolygonGetBoundary() throws Exception {
        Geometry g = this.reader.read("POLYGON((0 0, 40 0, 40 40, 0 40, 0 0),(10 10, 30 10, 30 30, 10 30, 10 10))");
        Geometry b = this.reader.read("MULTILINESTRING((0 0, 40 0, 40 40, 0 40, 0 0),(10 10, 30 10, 30 30, 10 30, 10 10))");
        MiscellaneousTest.assertTrue((boolean)b.equalsExact(g.getBoundary()));
    }

    public void testMultiPolygonGetBoundary1() throws Exception {
        Geometry g = this.reader.read("MULTIPOLYGON((  (0 0, 40 0, 40 40, 0 40, 0 0),   (10 10, 30 10, 30 30, 10 30, 10 10)  ),(  (200 200, 210 200, 210 210, 200 200) )  )");
        Geometry b = this.reader.read("MULTILINESTRING((0 0, 40 0, 40 40, 0 40, 0 0),(10 10, 30 10, 30 30, 10 30, 10 10),(200 200, 210 200, 210 210, 200 200))");
        MiscellaneousTest.assertTrue((boolean)b.equalsExact(g.getBoundary()));
    }

    public void testMultiPolygonIsSimple2() throws Exception {
        Geometry g = this.reader.read("MULTIPOLYGON(((10 10, 10 20, 20 20, 20 15, 10 10)), ((60 60, 70 70, 80 60, 60 60))  )");
        MiscellaneousTest.assertTrue((boolean)g.isSimple());
    }

    public void testMultiLineStringGetBoundary1() throws Exception {
        Geometry g = this.reader.read("MULTILINESTRING((0 0,  100 0, 50 50),(50 50, 50 -50))");
        Geometry m = this.reader.read("MULTIPOINT(0 0, 50 -50)");
        MiscellaneousTest.assertTrue((boolean)m.equalsExact(g.getBoundary()));
    }

    public void testMultiLineStringGetBoundary2() throws Exception {
        Geometry g = this.reader.read("MULTILINESTRING((0 0,  100 0, 50 50),(50 50, 50 0))");
        Geometry m = this.reader.read("MULTIPOINT(0 0, 50 0)");
        MiscellaneousTest.assertTrue((boolean)m.equalsExact(g.getBoundary()));
    }

    public void testCoordinateNaN() {
        Coordinate c1 = new Coordinate();
        MiscellaneousTest.assertTrue((!Double.isNaN(c1.x) ? 1 : 0) != 0);
        MiscellaneousTest.assertTrue((!Double.isNaN(c1.y) ? 1 : 0) != 0);
        MiscellaneousTest.assertTrue((boolean)Double.isNaN(c1.z));
        Coordinate c2 = new Coordinate(3.0, 4.0);
        MiscellaneousTest.assertEquals((double)3.0, (double)c2.x, (double)1.0E-10);
        MiscellaneousTest.assertEquals((double)4.0, (double)c2.y, (double)1.0E-10);
        MiscellaneousTest.assertTrue((boolean)Double.isNaN(c2.z));
        MiscellaneousTest.assertEquals((Object)c1, (Object)c1);
        MiscellaneousTest.assertEquals((Object)c2, (Object)c2);
        MiscellaneousTest.assertTrue((!c1.equals((Object)c2) ? 1 : 0) != 0);
        MiscellaneousTest.assertEquals((Object)new Coordinate(), (Object)new Coordinate(0.0, 0.0));
        MiscellaneousTest.assertEquals((Object)new Coordinate(3.0, 5.0), (Object)new Coordinate(3.0, 5.0));
        MiscellaneousTest.assertEquals((Object)new Coordinate(3.0, 5.0, Double.NaN), (Object)new Coordinate(3.0, 5.0, Double.NaN));
        MiscellaneousTest.assertTrue((boolean)new Coordinate(3.0, 5.0, 0.0).equals((Object)new Coordinate(3.0, 5.0, Double.NaN)));
    }

    public void testPredicatesReturnFalseForEmptyGeometries() {
        Point p1 = new GeometryFactory().createPoint((Coordinate)null);
        Point p2 = new GeometryFactory().createPoint(new Coordinate(5.0, 5.0));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p1.equals((Geometry)p2));
        MiscellaneousTest.assertEquals((boolean)true, (boolean)p1.disjoint((Geometry)p2));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p1.intersects((Geometry)p2));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p1.touches((Geometry)p2));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p1.crosses((Geometry)p2));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p1.within((Geometry)p2));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p1.contains((Geometry)p2));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p1.overlaps((Geometry)p2));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p2.equals((Geometry)p1));
        MiscellaneousTest.assertEquals((boolean)true, (boolean)p2.disjoint((Geometry)p1));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p2.intersects((Geometry)p1));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p2.touches((Geometry)p1));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p2.crosses((Geometry)p1));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p2.within((Geometry)p1));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p2.contains((Geometry)p1));
        MiscellaneousTest.assertEquals((boolean)false, (boolean)p2.overlaps((Geometry)p1));
    }
}

