/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.PerturbedGridPolygonBuilder;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import test.jts.perf.algorithm.PointInAreaStressTester;

public class IndexedPointInAreaStressTest
extends TestCase {
    PrecisionModel pmFixed_1 = new PrecisionModel(1.0);

    public static void main(String[] args) {
        TestRunner.run(IndexedPointInAreaStressTest.class);
    }

    public IndexedPointInAreaStressTest(String name) {
        super(name);
    }

    public void testGrid() {
        GeometryFactory geomFactory = new GeometryFactory(this.pmFixed_1);
        PerturbedGridPolygonBuilder gridBuilder = new PerturbedGridPolygonBuilder(geomFactory);
        gridBuilder.setNumLines(20);
        gridBuilder.setLineWidth(10.0);
        gridBuilder.setSeed(1185072199562L);
        Geometry area = gridBuilder.getGeometry();
        IndexedPointInAreaLocator pia = new IndexedPointInAreaLocator(area);
        PointInAreaStressTester gridTester = new PointInAreaStressTester(geomFactory, area);
        gridTester.setNumPoints(100000);
        gridTester.setPIA((PointOnGeometryLocator)pia);
        boolean isCorrect = gridTester.run();
        IndexedPointInAreaStressTest.assertTrue((boolean)isCorrect);
    }
}

