/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainBuilder;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.noding.BasicSegmentString;

class MCIndexedGeometry {
    private SpatialIndex index = new STRtree();

    public MCIndexedGeometry(Geometry geom) {
        this.init(geom);
    }

    private void init(Geometry geom) {
        List lines = LinearComponentExtracter.getLines((Geometry)geom);
        for (LineString line : lines) {
            Coordinate[] pts = line.getCoordinates();
            this.addLine(pts);
        }
    }

    private void addLine(Coordinate[] pts) {
        BasicSegmentString segStr = new BasicSegmentString(pts, null);
        List segChains = MonotoneChainBuilder.getChains((Coordinate[])segStr.getCoordinates(), (Object)segStr);
        for (MonotoneChain mc : segChains) {
            this.index.insert(mc.getEnvelope(), (Object)mc);
        }
    }

    public List query(Envelope searchEnv) {
        return this.index.query(searchEnv);
    }
}

