/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import org.locationtech.jts.algorithm.MinimumBoundingCircle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.util.Assert;

public class MinimumBoundingCircleStressTest {
    GeometryFactory geomFact = new GeometryFactory();

    public static void main(String[] args) {
        try {
            new MinimumBoundingCircleStressTest().run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void run() {
        while (true) {
            int n = (int)(10000.0 * Math.random());
            this.run(n);
        }
    }

    void run(int nPts) {
        Coordinate[] randPts = this.createRandomPoints(nPts);
        MultiPoint mp = this.geomFact.createMultiPoint(randPts);
        MinimumBoundingCircle mbc = new MinimumBoundingCircle((Geometry)mp);
        Coordinate centre = mbc.getCentre();
        double radius = mbc.getRadius();
        System.out.println("Testing " + nPts + " random points.  Radius = " + radius);
        this.checkWithinCircle(randPts, centre, radius, 1.0E-4);
    }

    void checkWithinCircle(Coordinate[] pts, Coordinate centre, double radius, double tolerance) {
        for (int i = 0; i < pts.length; ++i) {
            Coordinate p = pts[i];
            double ptRadius = centre.distance(p);
            double error = ptRadius - radius;
            if (!(error > tolerance)) continue;
            Assert.shouldNeverReachHere();
        }
    }

    Coordinate[] createRandomPoints(int n) {
        Coordinate[] pts = new Coordinate[n];
        for (int i = 0; i < n; ++i) {
            double x = 100.0 * Math.random();
            double y = 100.0 * Math.random();
            pts[i] = new Coordinate(x, y);
        }
        return pts;
    }
}

