/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.PerturbedGridPolygonBuilder;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import test.jts.perf.algorithm.PointInAreaStressTester;

public class SimpleRayCrossingStressTest
extends TestCase {
    PrecisionModel pmFixed_1 = new PrecisionModel(1.0);

    public static void main(String[] args) {
        TestRunner.run(SimpleRayCrossingStressTest.class);
    }

    public SimpleRayCrossingStressTest(String name) {
        super(name);
    }

    public void testGrid() {
        GeometryFactory geomFactory = new GeometryFactory(this.pmFixed_1);
        PerturbedGridPolygonBuilder gridBuilder = new PerturbedGridPolygonBuilder(geomFactory);
        gridBuilder.setNumLines(20);
        gridBuilder.setLineWidth(10.0);
        Geometry area = gridBuilder.getGeometry();
        SimpleRayCrossingPointInAreaLocator pia = new SimpleRayCrossingPointInAreaLocator(area);
        PointInAreaStressTester gridTester = new PointInAreaStressTester(geomFactory, area);
        gridTester.setNumPoints(100000);
        gridTester.setPIA(pia);
        boolean isCorrect = gridTester.run();
        SimpleRayCrossingStressTest.assertTrue((boolean)isCorrect);
    }

    static class SimpleRayCrossingPointInAreaLocator
    implements PointOnGeometryLocator {
        private Geometry geom;

        public SimpleRayCrossingPointInAreaLocator(Geometry geom) {
            this.geom = geom;
        }

        public int locate(Coordinate p) {
            RayCrossingCounter rcc = new RayCrossingCounter(p);
            RayCrossingSegmentFilter filter = new RayCrossingSegmentFilter(rcc);
            this.geom.apply((CoordinateSequenceFilter)filter);
            return rcc.getLocation();
        }

        static class RayCrossingSegmentFilter
        implements CoordinateSequenceFilter {
            private RayCrossingCounter rcc;
            private Coordinate p0 = new Coordinate();
            private Coordinate p1 = new Coordinate();

            public RayCrossingSegmentFilter(RayCrossingCounter rcc) {
                this.rcc = rcc;
            }

            public void filter(CoordinateSequence seq, int i) {
                if (i == 0) {
                    return;
                }
                seq.getCoordinate(i - 1, this.p0);
                seq.getCoordinate(i, this.p1);
                this.rcc.countSegment(this.p0, this.p1);
            }

            public boolean isDone() {
                return this.rcc.isOnSegment();
            }

            public boolean isGeometryChanged() {
                return false;
            }
        }
    }
}

