/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.dissolve;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.dissolve.LineDissolver;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.util.Memory;
import test.jts.junit.GeometryUtils;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;

public class LineDissolvePerfTest
extends PerformanceTestCase {
    Collection data;

    public static void main(String[] args) {
        PerformanceTestRunner.run(LineDissolvePerfTest.class);
    }

    public LineDissolvePerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{1, 2, 3, 4, 5});
        this.setRunIterations(1);
    }

    @Override
    public void setUp() throws IOException, ParseException {
        System.out.println("Loading data...");
        this.data = GeometryUtils.readWKTFile("/Users/mdavis/myproj/jts/svn/jts-topo-suite/trunk/jts/testdata/world.wkt");
    }

    public void runDissolver_World() {
        LineDissolver dis = new LineDissolver();
        dis.add(this.data);
        Geometry result = dis.getResult();
        System.out.println();
        System.out.println(Memory.allString());
    }

    public void runBruteForce_World() {
        Geometry result = this.dissolveLines(this.data);
        System.out.println(Memory.allString());
    }

    private Geometry dissolveLines(Collection lines) {
        Geometry linesGeom = this.extractLines(lines);
        return this.dissolveLines(linesGeom);
    }

    private Geometry dissolveLines(Geometry lines) {
        Geometry dissolved = lines.union();
        LineMerger merger = new LineMerger();
        merger.add(dissolved);
        Collection mergedColl = merger.getMergedLineStrings();
        Geometry merged = lines.getFactory().buildGeometry(mergedColl);
        return merged;
    }

    Geometry extractLines(Collection geoms) {
        GeometryFactory factory = null;
        ArrayList lines = new ArrayList();
        for (Geometry g : geoms) {
            if (factory == null) {
                factory = g.getFactory();
            }
            lines.addAll(LinearComponentExtracter.getLines((Geometry)g));
        }
        return factory.buildGeometry(geoms);
    }
}

