/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.geom.prep;

import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.util.Stopwatch;
import test.jts.perf.geom.prep.TestDataBuilder;

public class PreparedLineIntersectsPerfTest {
    static final int MAX_ITER = 1;
    static final int NUM_AOI_PTS = 2000;
    static final int NUM_LINES = 50000;
    static final int NUM_LINE_PTS = 10;
    static PrecisionModel pm = new PrecisionModel();
    static GeometryFactory fact = new GeometryFactory(pm, 0);
    TestDataBuilder builder = new TestDataBuilder();
    Stopwatch sw = new Stopwatch();
    boolean testFailed = false;

    public static void main(String[] args) {
        PreparedLineIntersectsPerfTest test = new PreparedLineIntersectsPerfTest();
        test.test();
    }

    public void test() {
        this.test(5);
        this.test(10);
        this.test(500);
        this.test(1000);
        this.test(2000);
    }

    public void test(int nPts) {
        this.builder.setTestDimension(1);
        Geometry target = this.builder.createSineStar(nPts).getBoundary();
        List lines = this.builder.createTestGeoms(target.getEnvelopeInternal(), 50000, 1.0, 10);
        System.out.println();
        this.test(target, lines);
    }

    public void test(Geometry g, List lines) {
        System.out.println("AOI # pts: " + g.getNumPoints() + "      # lines: " + lines.size() + "   # pts in line: " + 10);
        Stopwatch sw = new Stopwatch();
        int count = 0;
        for (int i = 0; i < 1; ++i) {
            count = this.testPrepGeomCached(g, lines);
        }
        System.out.println("Count of intersections = " + count);
        System.out.println("Finished in " + sw.getTimeString());
    }

    public int testOriginal(Geometry g, List lines) {
        System.out.println("Using orginal JTS algorithm");
        int count = 0;
        for (LineString line : lines) {
            if (!g.intersects((Geometry)line)) continue;
            ++count;
        }
        return count;
    }

    public int testPrepGeomCached(Geometry g, List lines) {
        System.out.println("Using cached Prepared Geometry");
        PreparedGeometryFactory pgFact = new PreparedGeometryFactory();
        PreparedGeometry prepGeom = pgFact.create(g);
        int count = 0;
        for (LineString line : lines) {
            if (!prepGeom.intersects((Geometry)line)) continue;
            ++count;
        }
        return count;
    }

    public int testPrepGeomNotCached(Geometry g, List lines) {
        System.out.println("Using NON-CACHED Prepared Geometry");
        PreparedGeometryFactory pgFact = new PreparedGeometryFactory();
        int count = 0;
        for (LineString line : lines) {
            PreparedGeometry prepGeom = pgFact.create(g);
            if (!prepGeom.intersects((Geometry)line)) continue;
            ++count;
        }
        return count;
    }
}

