/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.buffer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.LineSegment;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;

public class DepthSegmentStressTest
extends PerformanceTestCase {
    private int iter = 0;

    public static void main(String[] args) {
        PerformanceTestRunner.run(DepthSegmentStressTest.class);
    }

    public DepthSegmentStressTest(String name) {
        super(name);
        this.setRunSize(new int[]{20});
        this.setRunIterations(100);
    }

    @Override
    public void startRun(int size) {
        System.out.println("Running with size " + size);
        this.iter = 0;
    }

    public void XXrunSort() {
        System.out.println("Iter # " + this.iter++);
        List segs = this.createRandomDepthSegments(100);
        Collections.sort(segs);
    }

    public void runMin() {
        System.out.println("Iter # " + this.iter++);
        List segs = this.createRandomDepthSegments(100);
        Collections.min(segs);
    }

    public void runCompare() {
        System.out.println("Iter # " + this.iter++);
        DepthSegment seg1 = this.createRandomDepthSegment();
        DepthSegment seg2 = this.createRandomDepthSegment();
        DepthSegment seg3 = this.createRandomDepthSegment();
        boolean fails = false;
        if (!this.isSymmetric(seg1, seg2)) {
            fails = true;
        }
        if (!this.isTransitive(seg1, seg2, seg3)) {
            fails = true;
        }
        if (fails) {
            System.out.println("FAILS!");
            throw new RuntimeException("FAILS!");
        }
    }

    public boolean isSymmetric(DepthSegment seg1, DepthSegment seg2) {
        int cmp21;
        int cmp12 = seg1.compareTo(seg2);
        return cmp12 == -(cmp21 = seg2.compareTo(seg1));
    }

    public boolean isTransitive(DepthSegment seg1, DepthSegment seg2, DepthSegment seg3) {
        int cmp12 = seg1.compareTo(seg2);
        int cmp23 = seg2.compareTo(seg3);
        int cmp13 = seg1.compareTo(seg3);
        if (cmp12 > 0 && cmp23 > 0 && cmp13 <= 0) {
            System.out.println(seg1 + " " + seg2 + " " + seg3);
            return false;
        }
        return true;
    }

    public List createRandomDepthSegments(int n) {
        ArrayList<DepthSegment> segs = new ArrayList<DepthSegment>();
        for (int i = 0; i < n; ++i) {
            segs.add(this.createRandomDepthSegment());
        }
        return segs;
    }

    int randint(int max) {
        return (int)((double)max * Math.random());
    }

    private DepthSegment createRandomDepthSegment() {
        double scale = 10.0;
        int max = 10;
        double x0 = this.randint(max);
        double y0 = this.randint(max);
        double ang = Math.PI * 2 * Math.random();
        double x1 = Math.rint(x0 + (double)max * Math.cos(ang));
        double y1 = Math.rint(y0 + (double)max * Math.sin(ang));
        LineSegment seg = new LineSegment(x0, y0, x1, y1);
        seg.normalize();
        return new DepthSegment(seg, 0);
    }

    double round(double x, double scale) {
        return (double)Math.round(x * scale) / scale;
    }

    private class DepthSegment
    implements Comparable {
        private LineSegment upwardSeg;
        private int leftDepth;

        public DepthSegment(LineSegment seg, int depth) {
            this.upwardSeg = new LineSegment(seg);
            this.leftDepth = depth;
        }

        public int compareTo(Object obj) {
            DepthSegment other = (DepthSegment)obj;
            if (!this.envelopesOverlap(this.upwardSeg, other.upwardSeg)) {
                return this.upwardSeg.compareTo((Object)other.upwardSeg);
            }
            int orientIndex = this.upwardSeg.orientationIndex(other.upwardSeg);
            if (orientIndex != 0) {
                return orientIndex;
            }
            orientIndex = -other.upwardSeg.orientationIndex(this.upwardSeg);
            if (orientIndex != 0) {
                return orientIndex;
            }
            return this.upwardSeg.compareTo((Object)other.upwardSeg);
        }

        public int XcompareTo(Object obj) {
            DepthSegment other = (DepthSegment)obj;
            if (this.isVertical() && other.isVertical() && this.upwardSeg.p0.x == other.upwardSeg.p0.x) {
                return this.compareX(this.upwardSeg, other.upwardSeg);
            }
            if (this.upwardSeg.maxX() <= other.upwardSeg.minX()) {
                return -1;
            }
            if (this.upwardSeg.minX() >= other.upwardSeg.maxX()) {
                return 1;
            }
            int orientIndex = this.upwardSeg.orientationIndex(other.upwardSeg);
            if (orientIndex != 0) {
                return orientIndex;
            }
            if (orientIndex == 0) {
                orientIndex = -1 * other.upwardSeg.orientationIndex(this.upwardSeg);
            }
            if (orientIndex != 0) {
                return orientIndex;
            }
            return this.compareX(this.upwardSeg, other.upwardSeg);
        }

        public boolean isVertical() {
            return this.upwardSeg.p0.x == this.upwardSeg.p1.x;
        }

        public boolean envelopesOverlap(LineSegment seg1, LineSegment seg2) {
            if (seg1.maxX() <= seg2.minX()) {
                return false;
            }
            if (seg2.maxX() <= seg1.minX()) {
                return false;
            }
            if (seg1.maxY() <= seg2.minY()) {
                return false;
            }
            return !(seg2.maxY() <= seg1.minY());
        }

        private int compareX(LineSegment seg0, LineSegment seg1) {
            int compare0 = seg0.p0.compareTo(seg1.p0);
            if (compare0 != 0) {
                return compare0;
            }
            return seg0.p1.compareTo(seg1.p1);
        }

        public String toString() {
            return this.upwardSeg.toString();
        }
    }
}

