/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.buffer;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.util.GeometricShapeFactory;
import org.locationtech.jts.util.Stopwatch;

public class PolygonBufferStressTest {
    static final int MAX_ITER = 50;
    static PrecisionModel pm = new PrecisionModel();
    static GeometryFactory fact = new GeometryFactory(pm, 0);
    static WKTReader wktRdr = new WKTReader(fact);
    static WKTWriter wktWriter = new WKTWriter();
    Stopwatch sw = new Stopwatch();
    boolean testFailed = false;

    public static void main(String[] args) {
        PolygonBufferStressTest test = new PolygonBufferStressTest();
        test.test();
    }

    public void test() {
        GeometricShapeFactory shapeFact = new GeometricShapeFactory(fact);
        Geometry g = this.getSampleGeometry();
        System.out.println(g);
        this.test(g);
    }

    private Geometry getSampleGeometry() {
        String wkt = "POLYGON ((260 400, 220 300, 80 300, 180 220, 40 200, 180 160, 60 20, 200 80, 280 20, 260 140, 440 20, 340 180, 520 160, 280 220, 460 340, 300 300, 260 400), (260 320, 240 260, 220 220, 160 180, 220 160, 200 100, 260 160, 300 140, 320 180, 260 200, 260 320))";
        Geometry g = null;
        try {
            g = wktRdr.read(wkt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.testFailed = true;
        }
        return g;
    }

    public void test(Geometry g) {
        int maxCount = 50;
        this.doAlternatingIteratedBuffer(g, 1.0, maxCount);
        if (this.testFailed) {
            System.out.println("FAILED!");
        }
    }

    public void doIteratedBuffer(Geometry g, double initDist, double distanceInc, int maxCount) {
        int i = 0;
        double dist = initDist;
        while (i < maxCount) {
            System.out.println("Iter: " + ++i + " --------------------------------------------------------");
            System.out.println("Buffer (" + (dist += distanceInc) + ")");
            g = this.getBuffer(g, dist);
        }
    }

    public void doAlternatingIteratedBuffer(Geometry g, double dist, int maxCount) {
        int i = 0;
        while (i < maxCount) {
            System.out.println("Iter: " + ++i + " --------------------------------------------------------");
            System.out.println("Pos Buffer (" + (dist += 1.0) + ")");
            g = this.getBuffer(g, dist);
            System.out.println("Neg Buffer (" + -dist + ")");
            g = this.getBuffer(g, -dist);
        }
    }

    private Geometry getBuffer(Geometry geom, double dist) {
        Geometry buf = geom.buffer(dist);
        System.out.println(this.sw.getTimeString());
        if (!buf.isValid()) {
            throw new RuntimeException("buffer not valid!");
        }
        return buf;
    }
}

