/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.predicate;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.SineStarFactory;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.util.GeometricShapeFactory;
import org.locationtech.jts.util.Stopwatch;

public class RectangleIntersectsPerfTest {
    static final int MAX_ITER = 10;
    static final int NUM_AOI_PTS = 2000;
    static final int NUM_LINES = 5000;
    static final int NUM_LINE_PTS = 1000;
    static PrecisionModel pm = new PrecisionModel();
    static GeometryFactory fact = new GeometryFactory(pm, 0);
    static WKTReader wktRdr = new WKTReader(fact);
    static WKTWriter wktWriter = new WKTWriter();
    Stopwatch sw = new Stopwatch();
    boolean testFailed = false;

    public static void main(String[] args) {
        RectangleIntersectsPerfTest test = new RectangleIntersectsPerfTest();
        test.test();
    }

    public void test() {
        this.test(500);
        this.test(100000);
    }

    void test(int nPts) {
        Geometry sinePolyCrinkly;
        double size = 100.0;
        Coordinate origin = new Coordinate(0.0, 0.0);
        Geometry sinePoly = this.createSineStar(origin, size, nPts).getBoundary();
        Geometry target = sinePolyCrinkly = GeometryPrecisionReducer.reduce((Geometry)sinePoly, (PrecisionModel)new PrecisionModel(size / 10.0));
        Geometry rect = this.createRectangle(origin, 5.0);
        this.testRectangles(target, 100, 5.0);
    }

    void testRectangles(Geometry target, int nRect, double rectSize) {
        Geometry[] rects = this.createRectangles(target.getEnvelopeInternal(), nRect, rectSize);
        this.test(rects, target);
    }

    void test(Geometry[] rect, Geometry g) {
        System.out.println("Target # pts: " + g.getNumPoints() + "  -- # Rectangles: " + rect.length);
        int maxCount = 10;
        Stopwatch sw = new Stopwatch();
        boolean count = false;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < rect.length; ++j) {
                rect[j].intersects(g);
            }
        }
        System.out.println("Finished in " + sw.getTimeString());
        System.out.println();
    }

    Geometry[] createRectangles(Envelope env, int nRect, double rectSize) {
        int nSide = 1 + (int)Math.sqrt(nRect);
        double dx = env.getWidth() / (double)nSide;
        double dy = env.getHeight() / (double)nSide;
        ArrayList<Geometry> rectList = new ArrayList<Geometry>();
        for (int i = 0; i < nSide; ++i) {
            for (int j = 0; j < nSide; ++j) {
                double baseX = env.getMinX() + (double)i * dx;
                double baseY = env.getMinY() + (double)j * dy;
                Envelope envRect = new Envelope(baseX, baseX + dx, baseY, baseY + dy);
                Geometry rect = fact.toGeometry(envRect);
                rectList.add(rect);
            }
        }
        return GeometryFactory.toGeometryArray(rectList);
    }

    Geometry createRectangle(Coordinate origin, double size) {
        GeometricShapeFactory gsf = new GeometricShapeFactory();
        gsf.setCentre(origin);
        gsf.setSize(size);
        gsf.setNumPoints(4);
        Polygon g = gsf.createRectangle();
        return g;
    }

    Geometry createSineStar(Coordinate origin, double size, int nPts) {
        SineStarFactory gsf = new SineStarFactory();
        gsf.setCentre(origin);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        gsf.setArmLengthRatio(2.0);
        gsf.setNumArms(20);
        Geometry poly = gsf.createSineStar();
        return poly;
    }
}

