/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.union;

import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.locationtech.jts.util.Stopwatch;

public class UnionPerfTester {
    public static final int CASCADED = 1;
    public static final int ITERATED = 2;
    public static final int BUFFER0 = 3;
    public static final int ORDERED = 4;
    static final int MAX_ITER = 1;
    static PrecisionModel pm = new PrecisionModel();
    static GeometryFactory fact = new GeometryFactory(pm, 0);
    static WKTReader wktRdr = new WKTReader(fact);
    static WKTWriter wktWriter = new WKTWriter();
    Stopwatch sw = new Stopwatch();
    GeometryFactory factory = new GeometryFactory();
    private List polys;

    public static void run(String testName, int testType, List polys) {
        UnionPerfTester test = new UnionPerfTester(polys);
        test.run(testName, testType);
    }

    public static void runAll(List polys) {
        UnionPerfTester test = new UnionPerfTester(polys);
        test.runAll();
    }

    public UnionPerfTester(List polys) {
        this.polys = polys;
    }

    public void runAll() {
        System.out.println("# items: " + this.polys.size());
        UnionPerfTester.run("Cascaded", 1, this.polys);
        UnionPerfTester.run("Iterated", 2, this.polys);
    }

    public void run(String testName, int testType) {
        System.out.println();
        System.out.println("======= Union Algorithm: " + testName + " ===========");
        Stopwatch sw = new Stopwatch();
        block5: for (int i = 0; i < 1; ++i) {
            Geometry union = null;
            switch (testType) {
                case 1: {
                    union = this.unionCascaded(this.polys);
                    continue block5;
                }
                case 2: {
                    union = this.unionAllSimple(this.polys);
                    continue block5;
                }
                case 3: {
                    union = this.unionAllBuffer(this.polys);
                }
            }
        }
        System.out.println("Finished in " + sw.getTimeString());
    }

    void printFormatted(Geometry geom) {
        WKTWriter writer = new WKTWriter();
        System.out.println(writer.writeFormatted(geom));
    }

    public Geometry unionAllSimple(List geoms) {
        Geometry unionAll = null;
        int count = 0;
        for (Geometry geom : geoms) {
            unionAll = unionAll == null ? geom.copy() : unionAll.union(geom);
            if (++count % 100 != 0) continue;
            System.out.print(".");
        }
        return unionAll;
    }

    public Geometry unionAllBuffer(List geoms) {
        Geometry gColl = this.factory.buildGeometry((Collection)geoms);
        Geometry unionAll = gColl.buffer(0.0);
        return unionAll;
    }

    public Geometry unionCascaded(List geoms) {
        return CascadedPolygonUnion.union((Collection)geoms);
    }

    void printItemEnvelopes(List tree) {
        Envelope itemEnv = new Envelope();
        for (Object o : tree) {
            if (o instanceof List) {
                this.printItemEnvelopes((List)o);
                continue;
            }
            if (!(o instanceof Geometry)) continue;
            itemEnv.expandToInclude(((Geometry)o).getEnvelopeInternal());
        }
        System.out.println(this.factory.toGeometry(itemEnv));
    }
}

