/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.valid;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.AffineTransformation;

class Comb {
    Comb() {
    }

    public static MultiPolygon crossedComb(Envelope env, int size, GeometryFactory geomFact) {
        Polygon comb1 = Comb.comb(env, size, geomFact);
        Coordinate centre = env.centre();
        AffineTransformation trans = AffineTransformation.rotationInstance((double)1.5707963267948966, (double)centre.x, (double)centre.y);
        Polygon comb2 = (Polygon)trans.transform((Geometry)comb1);
        MultiPolygon mp = geomFact.createMultiPolygon(new Polygon[]{comb1, comb2});
        return mp;
    }

    public static Polygon comb(Envelope env, int nArms, GeometryFactory geomFact) {
        int npts = 4 * (nArms - 1) + 2 + 2 + 1;
        Coordinate[] pts = new Coordinate[npts];
        double armWidth = env.getWidth() / (double)(2 * nArms - 1);
        double armLen = env.getHeight() - armWidth;
        double xBase = env.getMinX();
        double yBase = env.getMinY();
        int ipts = 0;
        for (int i = 0; i < nArms; ++i) {
            double x1 = xBase + (double)(i * 2) * armWidth;
            double y1 = yBase + armLen + armWidth;
            pts[ipts++] = new Coordinate(x1, y1);
            pts[ipts++] = new Coordinate(x1 + armWidth, y1);
            if (i >= nArms - 1) continue;
            pts[ipts++] = new Coordinate(x1 + armWidth, yBase + armWidth);
            pts[ipts++] = new Coordinate(x1 + 2.0 * armWidth, yBase + armWidth);
        }
        pts[ipts++] = new Coordinate(env.getMaxX(), yBase);
        pts[ipts++] = new Coordinate(xBase, yBase);
        pts[ipts++] = new Coordinate(pts[0]);
        return geomFact.createPolygon(pts);
    }
}

