/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.valid;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.util.Assert;

public class QuadtreeNestedRingTester {
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private Envelope totalEnv = new Envelope();
    private Quadtree quadtree;
    private Coordinate nestedPt;

    public QuadtreeNestedRingTester(GeometryGraph graph) {
        this.graph = graph;
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public void add(LinearRing ring) {
        this.rings.add(ring);
        this.totalEnv.expandToInclude(ring.getEnvelopeInternal());
    }

    public boolean isNonNested() {
        this.buildQuadtree();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing innerRing = (LinearRing)this.rings.get(i);
            Coordinate[] innerRingPts = innerRing.getCoordinates();
            List results = this.quadtree.query(innerRing.getEnvelopeInternal());
            for (int j = 0; j < results.size(); ++j) {
                LinearRing searchRing = (LinearRing)results.get(j);
                Coordinate[] searchRingPts = searchRing.getCoordinates();
                if (innerRing == searchRing || !innerRing.getEnvelopeInternal().intersects(searchRing.getEnvelopeInternal())) continue;
                Coordinate innerRingPt = IsValidOp.findPtNotNode((Coordinate[])innerRingPts, (LinearRing)searchRing, (GeometryGraph)this.graph);
                Assert.isTrue((innerRingPt != null ? 1 : 0) != 0, (String)"Unable to find a ring point not a node of the search ring");
                boolean isInside = PointLocation.isInRing((Coordinate)innerRingPt, (Coordinate[])searchRingPts);
                if (!isInside) continue;
                this.nestedPt = innerRingPt;
                return false;
            }
        }
        return true;
    }

    private void buildQuadtree() {
        this.quadtree = new Quadtree();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing ring = (LinearRing)this.rings.get(i);
            Envelope env = ring.getEnvelopeInternal();
            this.quadtree.insert(env, (Object)ring);
        }
    }
}

