/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.valid;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;

class StarCross {
    StarCross() {
    }

    public static Polygon star(Envelope env, int nSeg, GeometryFactory geomFact) {
        Coordinate[] pts = new Coordinate[nSeg + 1];
        Coordinate centre = env.centre();
        double len = 0.5 * Math.min(env.getHeight(), env.getWidth());
        double angInc = Math.PI + Math.PI * 2 / (double)nSeg;
        double ang = 0.0;
        for (int i = 0; i < nSeg; ++i) {
            double x = centre.x + len * Math.cos(ang);
            double y = centre.x + len * Math.sin(ang);
            pts[i] = new Coordinate(x, y);
            ang += angInc;
        }
        pts[nSeg] = new Coordinate(pts[0]);
        return geomFact.createPolygon(pts);
    }
}

