/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.valid;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.index.sweepline.SweepLineIndex;
import org.locationtech.jts.index.sweepline.SweepLineInterval;
import org.locationtech.jts.index.sweepline.SweepLineOverlapAction;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.util.Assert;

public class SweeplineNestedRingTester {
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private SweepLineIndex sweepLine;
    private Coordinate nestedPt = null;

    public SweeplineNestedRingTester(GeometryGraph graph) {
        this.graph = graph;
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public void add(LinearRing ring) {
        this.rings.add(ring);
    }

    public boolean isNonNested() {
        this.buildIndex();
        OverlapAction action = new OverlapAction();
        this.sweepLine.computeOverlaps((SweepLineOverlapAction)action);
        return action.isNonNested;
    }

    private void buildIndex() {
        this.sweepLine = new SweepLineIndex();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing ring = (LinearRing)this.rings.get(i);
            Envelope env = ring.getEnvelopeInternal();
            SweepLineInterval sweepInt = new SweepLineInterval(env.getMinX(), env.getMaxX(), (Object)ring);
            this.sweepLine.add(sweepInt);
        }
    }

    private boolean isInside(LinearRing innerRing, LinearRing searchRing) {
        Coordinate[] innerRingPts = innerRing.getCoordinates();
        Coordinate[] searchRingPts = searchRing.getCoordinates();
        if (!innerRing.getEnvelopeInternal().intersects(searchRing.getEnvelopeInternal())) {
            return false;
        }
        Coordinate innerRingPt = IsValidOp.findPtNotNode((Coordinate[])innerRingPts, (LinearRing)searchRing, (GeometryGraph)this.graph);
        Assert.isTrue((innerRingPt != null ? 1 : 0) != 0, (String)"Unable to find a ring point not a node of the search ring");
        boolean isInside = PointLocation.isInRing((Coordinate)innerRingPt, (Coordinate[])searchRingPts);
        if (isInside) {
            this.nestedPt = innerRingPt;
            return true;
        }
        return false;
    }

    class OverlapAction
    implements SweepLineOverlapAction {
        boolean isNonNested = true;

        OverlapAction() {
        }

        public void overlap(SweepLineInterval s0, SweepLineInterval s1) {
            LinearRing searchRing;
            LinearRing innerRing = (LinearRing)s0.getItem();
            if (innerRing == (searchRing = (LinearRing)s1.getItem())) {
                return;
            }
            if (SweeplineNestedRingTester.this.isInside(innerRing, searchRing)) {
                this.isNonNested = false;
            }
        }
    }
}

