/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.triangulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.util.Memory;
import org.locationtech.jts.util.Stopwatch;

public class DelaunayRobustTest {
    static final GeometryFactory geomFact = new GeometryFactory();
    static final double SIDE_LEN = 1.0;
    static final double BASE_OFFSET = 1.0E7;

    public static void main(String[] args) {
        DelaunayRobustTest test = new DelaunayRobustTest();
        test.run();
    }

    public void run() {
        this.run(100000);
    }

    public void run(int nPts) {
        System.out.println("Base offset: 1.0E7");
        List pts = this.randomPointsInGrid(nPts, 1.0E7, 1.0E7);
        System.out.println("# pts: " + pts.size());
        Stopwatch sw = new Stopwatch();
        DelaunayTriangulationBuilder builder = new DelaunayTriangulationBuilder();
        builder.setSites((Collection)pts);
        builder.getSubdivision();
        System.out.println("  --  Time: " + sw.getTimeString() + "  Mem: " + Memory.usedTotalString());
    }

    List randomPointsInGrid(int nPts, double basex, double basey) {
        ArrayList<Coordinate> pts = new ArrayList<Coordinate>();
        int nSide = (int)Math.sqrt(nPts) + 1;
        for (int i = 0; i < nSide; ++i) {
            for (int j = 0; j < nSide; ++j) {
                double x = basex + (double)i * 1.0 + 1.0 * Math.random();
                double y = basey + (double)j * 1.0 + 1.0 * Math.random();
                pts.add(new Coordinate(x, y));
            }
        }
        return pts;
    }

    List randomPoints(int nPts) {
        ArrayList<Coordinate> pts = new ArrayList<Coordinate>();
        for (int i = 0; i < nPts; ++i) {
            double x = 1.0 * Math.random();
            double y = 1.0 * Math.random();
            pts.add(new Coordinate(x, y));
        }
        return pts;
    }
}

