/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.triangulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.util.Stopwatch;

public class VoronoiPerfTest {
    static final GeometryFactory geomFact = new GeometryFactory();
    static final double SIDE_LEN = 10.0;

    public static void main(String[] args) {
        VoronoiPerfTest test = new VoronoiPerfTest();
        test.run();
    }

    public void run() {
        this.run(10);
        this.run(100);
        this.run(1000);
        this.run(10000);
        this.run(100000);
        this.run(1000000);
    }

    public void run(int nPts) {
        List pts = this.randomPoints(nPts);
        Stopwatch sw = new Stopwatch();
        DelaunayTriangulationBuilder builder = new DelaunayTriangulationBuilder();
        builder.setSites((Collection)pts);
        Geometry g = builder.getEdges(geomFact);
        System.out.println("# pts: " + pts.size() + "  --  " + sw.getTimeString());
    }

    List randomPoints(int nPts) {
        ArrayList<Coordinate> pts = new ArrayList<Coordinate>();
        int nSide = (int)Math.sqrt(nPts) + 1;
        for (int i = 0; i < nSide; ++i) {
            for (int j = 0; j < nSide; ++j) {
                double x = (double)i * 10.0 + 10.0 * Math.random();
                double y = (double)j * 10.0 + 10.0 * Math.random();
                pts.add(new Coordinate(x, y));
            }
        }
        return pts;
    }
}

