/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.PointF;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.geo.drawing.Draw;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class ChartColorBar
extends ChartLegend {
    private List<Double> tickLocations = new ArrayList<Double>();
    private List<ChartText> tickLabels = new ArrayList<ChartText>();
    private boolean autoTick = true;
    private boolean insideTick = true;
    private float tickLength = 5.0f;
    private boolean tickVisible = true;
    private float tickWidth = 1.0f;
    private Color tickColor = Color.black;
    private boolean drawMinLabel = false;
    private boolean drawMaxLabel = false;

    public ChartColorBar(LegendScheme ls) {
        super(ls);
    }

    public List<Double> getTickLocations() {
        return this.tickLocations;
    }

    public void setTickLocations(List<Number> value) {
        this.tickLocations.clear();
        this.tickLabels.clear();
        for (Number v : value) {
            this.tickLocations.add(v.doubleValue());
            this.tickLabels.add(new ChartText(DataConvert.removeTailingZeros((String)String.valueOf(v))));
        }
        this.autoTick = false;
    }

    public void setTickLocations(double[] value) {
        this.tickLocations.clear();
        this.tickLabels.clear();
        for (double v : value) {
            this.tickLocations.add(v);
            this.tickLabels.add(new ChartText(DataConvert.removeTailingZeros((String)String.valueOf(v))));
        }
        this.autoTick = false;
    }

    public List<ChartText> getTickLabels() {
        return this.tickLabels;
    }

    public List<String> getTickLabelText() {
        ArrayList<String> strs = new ArrayList<String>();
        for (ChartText ct : this.tickLabels) {
            strs.add(ct.toString());
        }
        return strs;
    }

    public void setTickLabelText(List<String> value) {
        this.tickLabels = new ArrayList<ChartText>();
        for (String v : value) {
            this.tickLabels.add(new ChartText(v));
        }
        this.autoTick = false;
    }

    public void setTickLabels(List<ChartText> value) {
        this.tickLabels = value;
    }

    public void setTickLabels_Number(List<Number> value) {
        this.tickLabels = new ArrayList<ChartText>();
        for (Number v : value) {
            this.tickLabels.add(new ChartText(v.toString()));
        }
        this.autoTick = false;
    }

    public boolean isAutoTick() {
        return this.autoTick;
    }

    public void setAutoTick(boolean value) {
        this.autoTick = value;
    }

    public float getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(int value) {
        this.tickLength = value;
    }

    public boolean isInsideTick() {
        return this.insideTick;
    }

    public void setInsideTick(boolean value) {
        this.insideTick = value;
    }

    public boolean isTickVisible() {
        return this.tickVisible;
    }

    public void setTickVisible(boolean value) {
        this.tickVisible = value;
    }

    public float getTickWidth() {
        return this.tickWidth;
    }

    public void setTickWidth(float value) {
        this.tickWidth = value;
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color value) {
        this.tickColor = value;
    }

    public boolean isDrawMinLabel() {
        return this.drawMinLabel;
    }

    public void setDrawMinLabel(boolean value) {
        this.drawMinLabel = value;
    }

    public boolean isDrawMaxLabel() {
        return this.drawMaxLabel;
    }

    public void setDrawMaxLabel(boolean value) {
        this.drawMaxLabel = value;
    }

    @Override
    public void draw(Graphics2D g, PointF point) {
        AffineTransform oldMatrix = g.getTransform();
        g.translate(point.X + this.xshift, point.Y + this.yshift);
        if (this.drawBackground) {
            g.setColor(this.background);
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height));
        }
        g.setStroke(new BasicStroke(1.0f));
        switch (this.orientation) {
            case HORIZONTAL: {
                this.drawHorizontalBarLegend(g, this.legendScheme);
                break;
            }
            case VERTICAL: {
                this.drawVerticalBarLegend(g, this.legendScheme);
            }
        }
        if (this.drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            g.setColor(this.neatLineColor);
            g.setStroke(new BasicStroke(this.neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    private void drawTickLine(Graphics2D g, PointF sP, float tickLen, boolean vertical, float shift) {
        if (vertical) {
            if (this.insideTick) {
                g.draw(new Line2D.Float(sP.X + shift, sP.Y, sP.X + shift, sP.Y - tickLen));
            } else {
                g.draw(new Line2D.Float(sP.X + shift, sP.Y, sP.X + shift, sP.Y + tickLen));
                sP.Y += tickLen;
            }
            sP.Y += 5.0f;
        } else {
            if (this.insideTick) {
                g.draw(new Line2D.Float(sP.X - tickLen, sP.Y + shift, sP.X, sP.Y + shift));
            } else {
                g.draw(new Line2D.Float(sP.X, sP.Y + shift, sP.X + tickLen, sP.Y + shift));
                sP.X += tickLen;
            }
            sP.X += 5.0f;
        }
    }

    private void drawTickLine(Graphics2D g, PointD sP, float tickLen, boolean vertical, double shift) {
        if (vertical) {
            if (this.insideTick) {
                g.draw(new Line2D.Double(sP.X + shift, sP.Y, sP.X + shift, sP.Y - (double)tickLen));
            } else {
                g.draw(new Line2D.Double(sP.X + shift, sP.Y, sP.X + shift, sP.Y + (double)tickLen));
                sP.Y += (double)tickLen;
            }
            sP.Y += 5.0;
        } else {
            if (this.insideTick) {
                g.draw(new Line2D.Double(sP.X - (double)tickLen, sP.Y + shift, sP.X, sP.Y + shift));
            } else {
                g.draw(new Line2D.Double(sP.X, sP.Y + shift, sP.X + (double)tickLen, sP.Y + shift));
                sP.X += (double)tickLen;
            }
            sP.X += 5.0;
        }
    }

    private void drawHorizontalBarLegend(Graphics2D g, LegendScheme aLS) {
        PointD aP = new PointD(0.0, 0.0);
        PointD sP = new PointD(0.0, 0.0);
        boolean DrawShape = true;
        boolean DrawFill = true;
        boolean DrawOutline = false;
        Color FillColor = Color.red;
        Color OutlineColor = Color.black;
        int bNum = aLS.getBreakNum();
        if (((ColorBreak)aLS.getLegendBreaks().get(bNum - 1)).isNoData()) {
            --bNum;
        }
        ArrayList<Integer> labelIdxs = new ArrayList<Integer>();
        ArrayList<String> tLabels = new ArrayList<String>();
        if (this.autoTick) {
            int tickGap = this.getTickGap(g);
            int sIdx = bNum % tickGap / 2;
            int labNum = bNum - 1;
            if (aLS.getLegendType() == LegendType.UNIQUE_VALUE) {
                ++labNum;
            } else if (this.drawMinLabel) {
                sIdx = 0;
                labNum = bNum;
            }
            while (sIdx < labNum) {
                labelIdxs.add(sIdx);
                sIdx += tickGap;
            }
        } else {
            for (int i = 0; i < bNum; ++i) {
                double v;
                ColorBreak cb = (ColorBreak)aLS.getLegendBreaks().get(i);
                if (i == bNum - 1 && cb.getStartValue().equals(cb.getEndValue()) || !this.tickLocations.contains(v = Double.parseDouble(cb.getEndValue().toString()))) continue;
                labelIdxs.add(i);
                int tickIdx = this.tickLocations.indexOf(v);
                tLabels.add(this.tickLabels.get(tickIdx).getText());
            }
        }
        this._hBarHeight = (double)this.legendWidth / (double)this.aspect;
        this._vBarWidth = (double)this.legendWidth / (double)bNum;
        float y_shift = 0.0f;
        if (this.label != null) {
            switch (this.labelLocation) {
                case "top": 
                case "in": {
                    y_shift = this.label.getDimension((Graphics2D)g).height + 5;
                }
            }
        }
        aP.Y = y_shift;
        for (int i = 0; i < bNum; ++i) {
            PolygonBreak aPGB;
            int idx = i;
            switch (aLS.getShapeType()) {
                case POINT: {
                    PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPB.isDrawShape();
                    DrawFill = aPB.isDrawFill();
                    FillColor = aPB.getColor();
                    break;
                }
                case POLYLINE: {
                    PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPLB.getDrawPolyline();
                    FillColor = aPLB.getColor();
                    break;
                }
                case POLYGON: {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPGB.isDrawShape();
                    DrawFill = aPGB.isDrawFill();
                    FillColor = aPGB.getColor();
                    break;
                }
                case IMAGE: {
                    ColorBreak aCB = (ColorBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = true;
                    DrawFill = true;
                    FillColor = aCB.getColor();
                }
            }
            if (DrawShape) {
                if (this.extendRect) {
                    if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                        PolygonBreak aPGB2 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                        aPGB2.setDrawOutline(false);
                        Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this._vBarWidth, (double)this._hBarHeight, (PolygonBreak)aPGB2, (Graphics2D)g);
                    } else {
                        Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this._vBarWidth, (double)this._hBarHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
                    }
                } else {
                    PolygonBreak aPGB3;
                    PointD[] Points;
                    double extendw = this._vBarWidth;
                    if (this.autoExtendFrac) {
                        extendw = this._hBarHeight;
                    }
                    if (i == 0) {
                        Points = new PointD[4];
                        Points[0] = new PointD();
                        Points[0].X = this._vBarWidth - extendw;
                        Points[0].Y = aP.Y + this._hBarHeight * 0.5;
                        Points[1] = new PointD();
                        Points[1].X = this._vBarWidth;
                        Points[1].Y = aP.Y;
                        Points[2] = new PointD();
                        Points[2].X = this._vBarWidth;
                        Points[2].Y = aP.Y + this._hBarHeight;
                        Points[3] = new PointD();
                        Points[3].X = this._vBarWidth - extendw;
                        Points[3].Y = aP.Y + this._hBarHeight * 0.5;
                        if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                            aPGB3 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                            aPGB3.setDrawOutline(false);
                            Draw.drawPolygon((PointD[])Points, (PolygonBreak)aPGB3, (Graphics2D)g);
                        } else {
                            Draw.drawPolygon((PointD[])Points, (Color)FillColor, (Color)OutlineColor, (boolean)DrawFill, (boolean)DrawOutline, (Graphics2D)g);
                        }
                    } else if (i == bNum - 1) {
                        Points = new PointD[4];
                        Points[0] = new PointD();
                        Points[0].X = (double)i * this._vBarWidth - 1.0;
                        Points[0].Y = aP.Y + this._hBarHeight;
                        Points[1] = new PointD();
                        Points[1].X = (double)i * this._vBarWidth - 1.0;
                        Points[1].Y = aP.Y;
                        Points[2] = new PointD();
                        Points[2].X = (double)i * this._vBarWidth + extendw;
                        Points[2].Y = aP.Y + this._hBarHeight * 0.5;
                        Points[3] = new PointD();
                        Points[3].X = (double)i * this._vBarWidth - 1.0;
                        Points[3].Y = aP.Y + this._hBarHeight;
                        if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                            aPGB3 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                            aPGB3.setDrawOutline(false);
                            Draw.drawPolygon((PointD[])Points, (PolygonBreak)aPGB3, (Graphics2D)g);
                        } else {
                            Draw.drawPolygon((PointD[])Points, (Color)FillColor, (Color)OutlineColor, (boolean)DrawFill, (boolean)DrawOutline, (Graphics2D)g);
                        }
                    } else if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                        aPGB = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                        aPGB.setDrawOutline(false);
                        Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this._vBarWidth, (double)this._hBarHeight, (PolygonBreak)aPGB, (Graphics2D)g);
                    } else {
                        Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this._vBarWidth, (double)this._hBarHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
                    }
                }
            }
            aP.X += this._vBarWidth;
        }
        g.setStroke(new BasicStroke(this.neatLineSize));
        g.setColor(this.neatLineColor);
        if (this.extendRect) {
            g.draw(new Rectangle2D.Double(0.0, y_shift, this._vBarWidth * (double)bNum, this._hBarHeight));
        } else {
            double extendw = this._vBarWidth;
            if (this.autoExtendFrac) {
                extendw = this._hBarHeight;
            }
            Path2D.Double p = new Path2D.Double();
            ((Path2D)p).moveTo(this._vBarWidth - extendw, this._hBarHeight / 2.0 + (double)y_shift);
            ((Path2D)p).lineTo(this._vBarWidth, y_shift);
            ((Path2D)p).lineTo(this._vBarWidth * (double)(bNum - 1), y_shift);
            ((Path2D)p).lineTo(this._vBarWidth * (double)(bNum - 1) + extendw, this._hBarHeight / 2.0 + (double)y_shift);
            ((Path2D)p).lineTo(this._vBarWidth * (double)(bNum - 1), this._hBarHeight + (double)y_shift);
            ((Path2D)p).lineTo(this._vBarWidth, this._hBarHeight + (double)y_shift);
            p.closePath();
            g.draw(p);
        }
        aP.X = -this._vBarWidth / 2.0;
        float tickLen = this.tickLength;
        if (this.insideTick && this._hBarHeight < (double)tickLen) {
            tickLen = (int)this._hBarHeight;
        }
        g.setStroke(new BasicStroke(this.tickWidth));
        g.setFont(this.tickLabelFont);
        g.setColor(this.tickColor);
        int idx = 0;
        for (int i = 0; i < bNum; ++i) {
            aP.X += this._vBarWidth;
            aP.Y = this._hBarHeight / 2.0 + (double)y_shift;
            if (!labelIdxs.contains(i)) continue;
            ColorBreak cb = (ColorBreak)aLS.getLegendBreaks().get(i);
            String caption = this.autoTick ? (aLS.getLegendType() == LegendType.UNIQUE_VALUE ? cb.getCaption() : DataConvert.removeTailingZeros((String)cb.getEndValue().toString())) : (String)tLabels.get(idx);
            if (aLS.getLegendType() == LegendType.UNIQUE_VALUE) {
                sP.X = aP.X;
                sP.Y = aP.Y + this._hBarHeight / 2.0 + 5.0;
                g.setColor(this.tickLabelColor);
                if (this.tickLabelAngle == 0.0f) {
                    Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                } else if (this.tickLabelAngle < 45.0f) {
                    Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                } else {
                    Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                }
            } else {
                sP.X = aP.X + this._vBarWidth / 2.0;
                sP.Y = aP.Y + this._hBarHeight / 2.0;
                PointD ssP = (PointD)sP.clone();
                if (this.autoTick) {
                    if (i < bNum - 1) {
                        g.setColor(this.tickColor);
                        this.drawTickLine(g, sP, tickLen, true, 0.0);
                        g.setColor(this.tickLabelColor);
                        if (this.tickLabelAngle == 0.0f) {
                            Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                        } else if (this.tickLabelAngle < 45.0f) {
                            Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                        } else {
                            Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                        }
                        if (this.drawMinLabel && i == 0) {
                            g.setColor(this.tickColor);
                            this.drawTickLine(g, ssP, tickLen, true, -this._vBarWidth);
                            caption = DataConvert.removeTailingZeros((String)cb.getStartValue().toString());
                            g.setColor(this.tickLabelColor);
                            if (this.tickLabelAngle == 0.0f) {
                                Draw.drawString((Graphics2D)g, (double)(ssP.X - this._vBarWidth), (double)ssP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                            } else if (this.tickLabelAngle < 45.0f) {
                                Draw.drawString((Graphics2D)g, (double)(ssP.X - this._vBarWidth), (double)ssP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                            } else {
                                Draw.drawString((Graphics2D)g, (double)(ssP.X - this._vBarWidth), (double)ssP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                            }
                        }
                    } else if (this.drawMaxLabel) {
                        g.setColor(this.tickColor);
                        this.drawTickLine(g, sP, tickLen, true, 0.0);
                        g.setColor(this.tickLabelColor);
                        if (this.tickLabelAngle == 0.0f) {
                            Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                        } else if (this.tickLabelAngle < 45.0f) {
                            Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                        } else {
                            Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                        }
                    }
                } else if (i == 0 && this.tickLocations.get(idx) == Double.parseDouble(cb.getStartValue().toString())) {
                    g.setColor(this.tickColor);
                    this.drawTickLine(g, sP, tickLen, true, -this._vBarWidth);
                    g.setColor(this.tickLabelColor);
                    if (this.tickLabelAngle == 0.0f) {
                        Draw.drawString((Graphics2D)g, (double)(sP.X - this._vBarWidth), (double)sP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                    } else if (this.tickLabelAngle < 45.0f) {
                        Draw.drawString((Graphics2D)g, (double)(sP.X - this._vBarWidth), (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                    } else {
                        Draw.drawString((Graphics2D)g, (double)(sP.X - this._vBarWidth), (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                    }
                } else {
                    g.setColor(this.tickColor);
                    this.drawTickLine(g, sP, tickLen, true, 0.0);
                    g.setColor(this.tickLabelColor);
                    if (this.tickLabelAngle == 0.0f) {
                        Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                    } else if (this.tickLabelAngle < 45.0f) {
                        Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                    } else {
                        Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                    }
                }
            }
            ++idx;
        }
        if (this.label != null) {
            g.setFont(this.label.getFont());
            g.setColor(this.label.getColor());
            switch (this.labelLocation) {
                case "top": 
                case "in": {
                    double sx = (double)this.legendWidth * 0.5;
                    double sy = 2.0;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "right": {
                    double sx = this.legendWidth + 5;
                    double sy = this._hBarHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "left": {
                    double sx = -5.0;
                    double sy = this._hBarHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (boolean)this.label.isUseExternalFont());
                    break;
                }
                default: {
                    double sx = (double)this.legendWidth * 0.5;
                    double sy = this.height - 2;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.BOTTOM, (boolean)this.label.isUseExternalFont());
                }
            }
        }
    }

    private void drawVerticalBarLegend(Graphics2D g, LegendScheme aLS) {
        PointD aP = new PointD(0.0, 0.0);
        PointD sP = new PointD(0.0, 0.0);
        boolean DrawShape = true;
        boolean DrawFill = true;
        boolean DrawOutline = false;
        Color FillColor = Color.red;
        Color OutlineColor = Color.black;
        int bNum = aLS.getBreakNum();
        if (((ColorBreak)aLS.getLegendBreaks().get(bNum - 1)).isNoData()) {
            --bNum;
        }
        ArrayList<Integer> labelIdxs = new ArrayList<Integer>();
        ArrayList<String> tLabels = new ArrayList<String>();
        if (this.autoTick) {
            int tickGap = this.getTickGap(g);
            int sIdx = bNum % tickGap / 2;
            int labNum = bNum - 1;
            if (aLS.getLegendType() == LegendType.UNIQUE_VALUE) {
                ++labNum;
            } else if (this.drawMinLabel) {
                sIdx = 0;
                labNum = bNum;
            }
            while (sIdx < labNum) {
                labelIdxs.add(sIdx);
                sIdx += tickGap;
            }
        } else {
            for (int i = 0; i < bNum; ++i) {
                int tickIdx;
                ColorBreak cb = (ColorBreak)aLS.getLegendBreaks().get(i);
                if (i == bNum - 1 && cb.getStartValue().equals(cb.getEndValue())) continue;
                double v = Double.parseDouble(cb.getEndValue().toString());
                if (this.tickLocations.contains(v)) {
                    labelIdxs.add(i);
                    tickIdx = this.tickLocations.indexOf(v);
                    tLabels.add(this.tickLabels.get(tickIdx).getText());
                }
                if (i != 0 || !this.tickLocations.contains(v = Double.parseDouble(cb.getStartValue().toString()))) continue;
                labelIdxs.add(i);
                tickIdx = this.tickLocations.indexOf(v);
                tLabels.add(this.tickLabels.get(tickIdx).getText());
            }
        }
        this._vBarWidth = (double)this.legendHeight / (double)this.aspect;
        this._hBarHeight = (double)this.legendHeight / (double)bNum;
        aP.Y = this.legendHeight;
        float x_shift = 0.0f;
        if (this.label != null) {
            switch (this.labelLocation) {
                case "left": 
                case "in": {
                    x_shift = this.label.getDimension((Graphics2D)g).height + 5;
                }
            }
        }
        aP.X = x_shift;
        for (int i = 0; i < bNum; ++i) {
            PolygonBreak aPGB;
            PointD[] Points;
            PolygonBreak aPGB2;
            int idx = i;
            switch (aLS.getShapeType()) {
                case POINT: {
                    PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPB.isDrawShape();
                    DrawFill = aPB.isDrawFill();
                    FillColor = aPB.getColor();
                    break;
                }
                case POLYLINE: {
                    PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPLB.getDrawPolyline();
                    FillColor = aPLB.getColor();
                    break;
                }
                case POLYGON: {
                    PolygonBreak aPGB3 = (PolygonBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPGB3.isDrawShape();
                    DrawFill = aPGB3.isDrawFill();
                    FillColor = aPGB3.getColor();
                    break;
                }
                case IMAGE: {
                    ColorBreak aCB = (ColorBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = true;
                    DrawFill = true;
                    FillColor = aCB.getColor();
                }
            }
            aP.Y -= this._hBarHeight;
            if (!DrawShape) continue;
            if (this.extendRect) {
                if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                    aPGB2 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                    aPGB2.setDrawOutline(false);
                    Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this._vBarWidth, (double)this._hBarHeight, (PolygonBreak)aPGB2, (Graphics2D)g);
                    continue;
                }
                Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this._vBarWidth, (double)this._hBarHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
                continue;
            }
            if (i == 0) {
                Points = new PointD[4];
                Points[0] = new PointD();
                Points[0].X = aP.X + this._vBarWidth * 0.5;
                Points[0].Y = this.legendHeight;
                Points[1] = new PointD();
                Points[1].X = aP.X;
                Points[1].Y = aP.Y;
                Points[2] = new PointD();
                Points[2].X = aP.X + this._vBarWidth;
                Points[2].Y = aP.Y;
                Points[3] = new PointD();
                Points[3].X = aP.X + this._vBarWidth * 0.5;
                Points[3].Y = this.legendHeight;
                if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                    aPGB = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                    aPGB.setDrawOutline(false);
                    Draw.drawPolygon((PointD[])Points, (PolygonBreak)aPGB, (Graphics2D)g);
                    continue;
                }
                Draw.drawPolygon((PointD[])Points, (Color)FillColor, (Color)OutlineColor, (boolean)DrawFill, (boolean)DrawOutline, (Graphics2D)g);
                continue;
            }
            if (i == bNum - 1) {
                Points = new PointD[4];
                Points[0] = new PointD();
                Points[0].X = aP.X;
                Points[0].Y = this._hBarHeight;
                Points[1] = new PointD();
                Points[1].X = aP.X + this._vBarWidth;
                Points[1].Y = this._hBarHeight;
                Points[2] = new PointD();
                Points[2].X = aP.X + this._vBarWidth * 0.5;
                Points[2].Y = 0.0;
                Points[3] = new PointD();
                Points[3].X = aP.X;
                Points[3].Y = this._hBarHeight;
                if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                    aPGB = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                    aPGB.setDrawOutline(false);
                    Draw.drawPolygon((PointD[])Points, (PolygonBreak)aPGB, (Graphics2D)g);
                    continue;
                }
                Draw.drawPolygon((PointD[])Points, (Color)FillColor, (Color)OutlineColor, (boolean)DrawFill, (boolean)DrawOutline, (Graphics2D)g);
                continue;
            }
            if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                aPGB2 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                aPGB2.setDrawOutline(false);
                Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this._vBarWidth, (double)this._hBarHeight, (PolygonBreak)aPGB2, (Graphics2D)g);
                continue;
            }
            Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this._vBarWidth, (double)this._hBarHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
        }
        g.setStroke(new BasicStroke(this.neatLineSize));
        g.setColor(this.neatLineColor);
        if (this.extendRect) {
            g.draw(new Rectangle2D.Double(x_shift, 0.0, this._vBarWidth, this._hBarHeight * (double)bNum));
        } else {
            Path2D.Double p = new Path2D.Double();
            ((Path2D)p).moveTo(this._vBarWidth / 2.0 + (double)x_shift, 0.0);
            ((Path2D)p).lineTo(x_shift, this._hBarHeight);
            ((Path2D)p).lineTo(x_shift, this._hBarHeight * (double)(bNum - 1));
            ((Path2D)p).lineTo(this._vBarWidth / 2.0 + (double)x_shift, this._hBarHeight * (double)bNum);
            ((Path2D)p).lineTo(this._vBarWidth + (double)x_shift, this._hBarHeight * (double)(bNum - 1));
            ((Path2D)p).lineTo(this._vBarWidth + (double)x_shift, this._hBarHeight);
            p.closePath();
            g.draw(p);
        }
        g.setStroke(new BasicStroke(this.tickWidth));
        aP.Y = (double)this.legendHeight + this._hBarHeight / 2.0;
        float tickLen = this.tickLength;
        if (this.insideTick && this._vBarWidth < (double)tickLen) {
            tickLen = (int)this._vBarWidth;
        }
        g.setFont(this.tickLabelFont);
        int idx = 0;
        for (int i = 0; i < bNum; ++i) {
            aP.X = this._vBarWidth / 2.0 + (double)x_shift;
            aP.Y -= this._hBarHeight;
            if (!labelIdxs.contains(i)) continue;
            ColorBreak cb = (ColorBreak)aLS.getLegendBreaks().get(i);
            String caption = this.autoTick ? (aLS.getLegendType() == LegendType.UNIQUE_VALUE ? cb.getCaption() : DataConvert.removeTailingZeros((String)cb.getEndValue().toString())) : (String)tLabels.get(idx);
            if (aLS.getLegendType() == LegendType.UNIQUE_VALUE) {
                sP.X = aP.X + this._vBarWidth / 2.0 + 5.0;
                sP.Y = aP.Y;
                g.setColor(this.tickLabelColor);
                Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
            } else {
                sP.X = aP.X + this._vBarWidth / 2.0;
                sP.Y = aP.Y - this._hBarHeight / 2.0;
                PointD ssP = (PointD)sP.clone();
                if (this.autoTick) {
                    if (i < bNum - 1) {
                        g.setColor(this.tickColor);
                        this.drawTickLine(g, sP, tickLen, false, 0.0);
                        g.setColor(this.tickLabelColor);
                        Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                        if (this.drawMinLabel && i == 0) {
                            g.setColor(this.tickColor);
                            this.drawTickLine(g, ssP, tickLen, false, this._hBarHeight);
                            caption = DataConvert.removeTailingZeros((String)cb.getStartValue().toString());
                            g.setColor(this.tickLabelColor);
                            Draw.drawString((Graphics2D)g, (double)ssP.X, (double)(ssP.Y + this._hBarHeight), (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                        }
                    } else if (this.drawMaxLabel) {
                        g.setColor(this.tickColor);
                        this.drawTickLine(g, sP, tickLen, false, 0.0);
                        g.setColor(this.tickLabelColor);
                        Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                    }
                } else if (i == 0 && this.tickLocations.get(idx) == Double.parseDouble(cb.getStartValue().toString())) {
                    g.setColor(this.tickColor);
                    this.drawTickLine(g, sP, tickLen, false, this._hBarHeight);
                    g.setColor(this.tickLabelColor);
                    Draw.drawString((Graphics2D)g, (double)sP.X, (double)(sP.Y + this._hBarHeight), (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                } else {
                    g.setColor(this.tickColor);
                    this.drawTickLine(g, sP, tickLen, false, 0.0);
                    g.setColor(this.tickLabelColor);
                    Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                }
            }
            ++idx;
        }
        if (this.label != null) {
            g.setFont(this.label.getFont());
            g.setColor(this.label.getColor());
            Dimension dim = Draw.getStringDimension((String)this.label.getText(), (Graphics2D)g);
            switch (this.labelLocation) {
                case "top": {
                    double sx = 0.0;
                    double sy = -5.0;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.LEFT, (YAlign)YAlign.BOTTOM, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "bottom": {
                    double sx = 0.0;
                    double sy = this.legendHeight + 5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.LEFT, (YAlign)YAlign.TOP, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "left": 
                case "in": {
                    double sx = 0.0;
                    double sy = (double)this.legendHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)90.0f, (boolean)this.label.isUseExternalFont());
                    break;
                }
                default: {
                    double sx = this.width - dim.height;
                    double sy = (double)this.legendHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)90.0f, (boolean)this.label.isUseExternalFont());
                }
            }
        }
    }

    @Override
    public Dimension getLegendDimension(Graphics2D g, Dimension limitDim) {
        if (this.legendScheme != null) {
            block0 : switch (this.orientation) {
                case VERTICAL: {
                    this.width = (int)((float)this.getTickWidth(g) + (float)limitDim.height * this.shrink / (float)this.aspect + 5.0f);
                    if (!this.insideTick) {
                        this.width = (int)((float)this.width + this.tickLength);
                    }
                    this.legendWidth = this.width;
                    this.legendHeight = this.height;
                    if (this.label == null) break;
                    g.setFont(this.label.getFont());
                    Dimension dim = Draw.getStringDimension((String)this.label.getText(), (Graphics2D)g);
                    switch (this.labelLocation) {
                        case "top": 
                        case "bottom": {
                            this.width = Math.max(this.width, dim.width);
                            break block0;
                        }
                    }
                    this.width += dim.height + 5;
                    break;
                }
                default: {
                    g.setFont(this.tickLabelFont);
                    this.height = (int)((float)this.getTickHeight(g) + (float)limitDim.width * this.shrink / (float)this.aspect + 5.0f);
                    if (!this.insideTick) {
                        this.height = (int)((float)this.height + this.tickLength);
                    }
                    this.legendWidth = this.width;
                    this.legendHeight = this.height;
                    if (this.label == null) break;
                    g.setFont(this.label.getFont());
                    Dimension dim = Draw.getStringDimension((String)this.label.getText(), (Graphics2D)g);
                    switch (this.labelLocation) {
                        case "right": 
                        case "left": {
                            break block0;
                        }
                    }
                    this.height += dim.height + 5;
                }
            }
        }
        return new Dimension(this.width, this.height);
    }
}

