/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.meteoinfo.chart.ChartElement;
import org.meteoinfo.chart.plot.MapPlot;
import org.meteoinfo.common.PointF;
import org.meteoinfo.geo.layout.ScaleBarType;
import org.meteoinfo.geo.layout.ScaleBarUnits;

public class ChartScaleBar
extends ChartElement {
    private MapPlot mapPlot;
    private boolean _antiAlias;
    private float lineWidth;
    private Font _font;
    private ScaleBarType _scaleBarType;
    private ScaleBarUnits _unit;
    private String _unitText;
    private int _numBreaks;
    private boolean _drawNeatLine;
    private Color _neatLineColor;
    private float _neatLineSize;
    private boolean _drawScaleText;
    private float _yShiftScale = 2.0f;

    public ChartScaleBar(MapPlot mapPlot) {
        this.width = 200.0f;
        this.height = 50.0f;
        this.mapPlot = mapPlot;
        this._antiAlias = true;
        this._scaleBarType = ScaleBarType.SCALE_LINE_1;
        this.lineWidth = 1.0f;
        this._drawNeatLine = false;
        this._neatLineColor = Color.black;
        this._neatLineSize = 1.0f;
        this._font = new Font("Arial", 0, 12);
        this._unit = ScaleBarUnits.KILOMETERS;
        this._unitText = "km";
        this._numBreaks = 4;
        this._drawScaleText = false;
    }

    public MapPlot getMapPlot() {
        return this.mapPlot;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float value) {
        this.lineWidth = value;
    }

    public ScaleBarType getScaleBarType() {
        return this._scaleBarType;
    }

    public void setScaleBarType(ScaleBarType type) {
        this._scaleBarType = type;
    }

    public boolean isDrawNeatLine() {
        return this._drawNeatLine;
    }

    public void setDrawNeatLine(boolean istrue) {
        this._drawNeatLine = istrue;
    }

    public Color getNeatLineColor() {
        return this._neatLineColor;
    }

    public void setNeatLineColor(Color color) {
        this._neatLineColor = color;
    }

    public float getNeatLineSize() {
        return this._neatLineSize;
    }

    public void setNeatLineSize(float size) {
        this._neatLineSize = size;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font font) {
        this._font = font;
    }

    public int getBreakNumber() {
        return this._numBreaks;
    }

    public void setBreakNumber(int num) {
        this._numBreaks = num;
    }

    public boolean isDrawScaleText() {
        return this._drawScaleText;
    }

    public void setDrawScaleText(boolean istrue) {
        this._drawScaleText = istrue;
    }

    public void draw(Graphics2D g, float x, float y) {
        AffineTransform oldMatrix = g.getTransform();
        g.translate(x, y);
        if (this._antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isDrawBackColor()) {
            g.setColor(this.getBackground());
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight()));
        }
        this.drawScaleBar(g);
        if (this._drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(this._neatLineSize - 1.0f, this._neatLineSize - 1.0f, this.getWidth() - this._neatLineSize, this.getHeight() - this._neatLineSize);
            g.setColor(this._neatLineColor);
            g.setStroke(new BasicStroke(this._neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    public void paintGraphics(Graphics2D g, PointF pageLocation) {
        AffineTransform oldMatrix = g.getTransform();
        PointF aP = this.pageToScreen(this.getX(), this.getY(), pageLocation, 1.0f);
        g.translate(aP.X, aP.Y);
        if (this._antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isDrawBackColor()) {
            g.setColor(this.getBackground());
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight()));
        }
        this.drawScaleBar(g);
        if (this._drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(this._neatLineSize - 1.0f, this._neatLineSize - 1.0f, this.getWidth() - this._neatLineSize, this.getHeight() - this._neatLineSize);
            g.setColor(this._neatLineColor);
            g.setStroke(new BasicStroke(this._neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    private void drawScaleBar(Graphics2D g) {
        FontMetrics metrics = g.getFontMetrics(this._font);
        float unitLegnth = metrics.stringWidth(this._unitText) * 2;
        float widthNoUnit = this.getWidth() - unitLegnth;
        long geoBreakWidth = (long)this.getGeoWidth(widthNoUnit / (float)this._numBreaks);
        if (geoBreakWidth < 1L) {
            return;
        }
        double n = Math.pow(10.0, String.valueOf(geoBreakWidth).length() - 1);
        geoBreakWidth = (long)(Math.floor((double)geoBreakWidth / n) * n);
        long breakWidth = (long)this.getWidth(geoBreakWidth);
        FontMetrics metrics1 = g.getFontMetrics(this._font);
        float fontHeight = metrics1.getHeight();
        float leftStart = (float)metrics1.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        double scale = (double)geoBreakWidth * this.getConversionFactor(this._unit) * 100.0 / ((double)(breakWidth / 96L) * 2.539999918);
        if (this._drawScaleText) {
            g.setFont(this._font);
            g.setColor(this.getForeground());
            g.drawString("1 : " + String.format("{0:0,0}", scale), leftStart - (float)(metrics.stringWidth(String.valueOf(Math.abs(0))) / 2), fontHeight * 2.5f);
        }
        switch (this._scaleBarType) {
            case SCALE_LINE_1: {
                this.drawScaleLine1(g, breakWidth, geoBreakWidth);
                break;
            }
            case SCALE_LINE_2: {
                this.drawScaleLine2(g, breakWidth, geoBreakWidth);
                break;
            }
            case ALTERNATING_BAR: {
                this.drawAlternatingBar(g, breakWidth, geoBreakWidth);
            }
        }
    }

    private double getConversionFactor(ScaleBarUnits unit) {
        switch (unit) {
            case KILOMETERS: {
                return 1000.0;
            }
        }
        return 1.0;
    }

    private double getGeoWidth(double width) {
        double geoWidth = width / this.mapPlot.getMapFrame().getMapView().getXScale() / this.getConversionFactor(this._unit);
        if (this.mapPlot.getMapFrame().getMapView().getProjection().isLonLatMap()) {
            geoWidth *= this.getLonDistScale();
        }
        return geoWidth;
    }

    private double getWidth(double geoWidth) {
        double width = geoWidth * this.mapPlot.getMapFrame().getMapView().getXScale() * this.getConversionFactor(this._unit);
        if (this.mapPlot.getMapFrame().getMapView().getProjection().isLonLatMap()) {
            width /= this.getLonDistScale();
        }
        return width;
    }

    private double getLonDistScale() {
        double pY = (this.mapPlot.getMapFrame().getMapView().getViewExtent().maxY + this.mapPlot.getMapFrame().getMapView().getViewExtent().minY) / 2.0;
        double ProjX = 0.0;
        double ProjY = pY;
        double pProjX = 1.0;
        double pProjY = pY;
        double dx = Math.abs(ProjX - pProjX);
        double dy = Math.abs(ProjY - pProjY);
        double y = (ProjY + pProjY) / 2.0;
        double factor = Math.cos(y * Math.PI / 180.0);
        double dist = Math.sqrt((dx *= factor) * dx + dy * dy);
        return dist *= 111319.5;
    }

    private void drawScaleLine1(Graphics2D g, long breakWidth, long geoBreakWidth) {
        FontMetrics metrics = g.getFontMetrics(this._font);
        float fontHeight = metrics.getHeight();
        float leftStart = (float)metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        int yShift = 10;
        g.setColor(this.getForeground());
        g.setStroke(new BasicStroke(this.lineWidth));
        g.draw(new Line2D.Float(leftStart, fontHeight * 1.6f + (float)yShift, leftStart + (float)(breakWidth * (long)this._numBreaks), fontHeight * 1.6f + (float)yShift));
        g.setFont(this._font);
        for (int i = 0; i <= this._numBreaks; ++i) {
            g.draw(new Line2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, leftStart, fontHeight * 1.6f + (float)yShift));
            g.drawString(String.valueOf(Math.abs(geoBreakWidth * (long)i)), leftStart - (float)(metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth * (long)i))) / 2), (float)yShift * this._yShiftScale);
            leftStart += (float)breakWidth;
        }
        g.drawString(this._unitText, leftStart - (float)breakWidth + fontHeight / 2.0f, fontHeight * 1.1f + (float)yShift * this._yShiftScale);
    }

    private void drawScaleLine2(Graphics2D g, long breakWidth, long geoBreakWidth) {
        FontMetrics metrics = g.getFontMetrics(this._font);
        float fontHeight = metrics.getHeight();
        float leftStart = (float)metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        int yShift = 5;
        g.setColor(this.getForeground());
        g.setStroke(new BasicStroke(this.lineWidth));
        g.draw(new Line2D.Float(leftStart, fontHeight * 1.6f + (float)yShift, leftStart + (float)(breakWidth * (long)this._numBreaks), fontHeight * 1.6f + (float)yShift));
        g.setFont(this._font);
        for (int i = 0; i <= this._numBreaks; ++i) {
            g.draw(new Line2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, leftStart, fontHeight + fontHeight * 1.1f + (float)yShift));
            g.drawString(String.valueOf(Math.abs(geoBreakWidth * (long)i)), leftStart - (float)(metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth * (long)i))) / 2), (float)yShift * this._yShiftScale);
            leftStart += (float)breakWidth;
        }
        g.drawString(this._unitText, leftStart - (float)breakWidth + fontHeight / 2.0f, fontHeight * 1.1f + (float)yShift * this._yShiftScale);
    }

    private void drawAlternatingBar(Graphics2D g, long breakWidth, long geoBreakWidth) {
        FontMetrics metrics = g.getFontMetrics(this._font);
        float fontHeight = metrics.getHeight();
        float leftStart = (float)metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        int yShift = 5;
        float rHeight = fontHeight / 2.0f;
        boolean isFill = false;
        g.setStroke(new BasicStroke(this.lineWidth));
        g.setColor(this.getForeground());
        g.setFont(this._font);
        for (int i = 0; i <= this._numBreaks; ++i) {
            if (i < this._numBreaks) {
                if (isFill) {
                    g.fill(new Rectangle2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, breakWidth, rHeight));
                }
                g.draw(new Rectangle2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, breakWidth, rHeight));
            }
            g.drawString(String.valueOf(Math.abs(geoBreakWidth * (long)i)), leftStart - (float)(metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth * (long)i))) / 2), (float)yShift * this._yShiftScale);
            leftStart += (float)breakWidth;
            isFill = !isFill;
        }
        g.setColor(this.getForeground());
        g.drawString(this._unitText, leftStart - (float)breakWidth + fontHeight / 2.0f, fontHeight * 1.1f + (float)yShift * this._yShiftScale);
    }

    @Override
    public void moveUpdate() {
    }

    @Override
    public void resizeUpdate() {
    }
}

