/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.axis;

import java.util.ArrayList;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.common.DataConvert;

public class LonLatAxis
extends Axis
implements Cloneable {
    private boolean drawDegreeSymbol = true;
    private boolean longitude;
    private boolean degreeSpace;

    public LonLatAxis(String label, boolean isX, boolean longitude) {
        super(label, isX);
        this.longitude = longitude;
        this.degreeSpace = false;
    }

    public LonLatAxis(String label, boolean isX) {
        this(label, isX, isX);
    }

    public LonLatAxis(Axis axis) {
        this(axis.getLabel().getText(), axis.isXAxis());
        this.autoTick = axis.autoTick;
        this.drawLabel = axis.drawLabel;
        this.drawTickLabel = axis.drawTickLabel;
        this.drawTickLine = axis.drawTickLine;
        this.insideTick = axis.insideTick;
        this.inverse = axis.inverse;
        this.setLabelColor(axis.getLabelColor());
        this.lineWidth = axis.lineWidth;
        this.lineStyle = axis.lineStyle;
        this.location = axis.location;
        this.maxValue = axis.maxValue;
        this.minValue = axis.minValue;
        this.minorTickNum = axis.minorTickNum;
        this.minorTickVisible = axis.minorTickVisible;
        this.tickColor = axis.tickColor;
        this.tickDeltaValue = axis.tickDeltaValue;
        this.tickLabelColor = axis.tickLabelColor;
        this.tickLabelFont = axis.tickLabelFont;
        this.tickLength = axis.tickLength;
        this.visible = axis.visible;
        this.positionType = axis.positionType;
        this.position = axis.position;
    }

    public boolean isDrawDegreeSymbol() {
        return this.drawDegreeSymbol;
    }

    public void setDrawDegreeSymbol(boolean value) {
        this.drawDegreeSymbol = value;
    }

    public boolean isLongitude() {
        return this.longitude;
    }

    public void setLongitude(boolean value) {
        this.longitude = value;
    }

    public boolean isDegreeSpace() {
        return this.degreeSpace;
    }

    public void setDegreeSpace(boolean value) {
        this.degreeSpace = value;
    }

    @Override
    public void updateTickLabels() {
        ArrayList<ChartText> tls = new ArrayList<ChartText>();
        for (double v : this.getTickValues()) {
            double value = v;
            if (value > 180.0) {
                value -= 360.0;
            }
            String lab = String.valueOf(value);
            lab = DataConvert.removeTailingZeros((String)lab);
            if (this.isLongitude()) {
                if (value == -180.0) {
                    lab = "180";
                } else if (value != 0.0 && value != 180.0) {
                    lab = lab.substring(0, 1).equals("-") ? lab.substring(1) + "W" : lab + "E";
                }
            } else if (value != 0.0) {
                lab = lab.substring(0, 1).equals("-") ? lab.substring(1) + "S" : lab + "N";
            }
            if (this.drawDegreeSymbol) {
                lab = lab.endsWith("E") || lab.endsWith("W") || lab.endsWith("N") || lab.endsWith("S") ? (this.degreeSpace ? lab.substring(0, lab.length() - 1) + String.valueOf('\u00ba') + " " + lab.substring(lab.length() - 1) : lab.substring(0, lab.length() - 1) + String.valueOf('\u00ba') + lab.substring(lab.length() - 1)) : lab + String.valueOf('\u00ba');
            }
            tls.add(new ChartText(lab));
        }
        this.setTickLabels(tls);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (LonLatAxis)super.clone();
    }
}

