/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.axis;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.chart.axis.TimeUnit;
import org.meteoinfo.common.util.JDateUtil;

public class TimeAxis
extends Axis
implements Cloneable {
    private String timeFormat = "yyyy-MM-dd";
    private TimeUnit timeUnit = TimeUnit.DAY;
    private boolean varFormat = true;

    public TimeAxis(String label, boolean xAxis) {
        super(label, xAxis);
    }

    public TimeAxis(Axis axis) {
        this(axis.getLabel().getText(), axis.isXAxis());
        this.autoTick = axis.autoTick;
        this.drawLabel = axis.drawLabel;
        this.drawTickLabel = axis.drawTickLabel;
        this.drawTickLine = axis.drawTickLine;
        this.insideTick = axis.insideTick;
        this.inverse = axis.inverse;
        this.setLabelColor(axis.getLabelColor());
        this.lineWidth = axis.lineWidth;
        this.lineStyle = axis.lineStyle;
        this.location = axis.location;
        this.maxValue = axis.maxValue;
        this.minValue = axis.minValue;
        this.minorTickNum = axis.minorTickNum;
        this.minorTickVisible = axis.minorTickVisible;
        this.tickColor = axis.tickColor;
        this.tickDeltaValue = axis.tickDeltaValue;
        this.tickLabelColor = axis.tickLabelColor;
        this.tickLabelFont = axis.tickLabelFont;
        this.tickLength = axis.tickLength;
        this.visible = axis.visible;
        this.positionType = axis.positionType;
        this.position = axis.position;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String value) {
        this.timeFormat = value;
        this.timeUnit = value.contains("s") ? TimeUnit.SECOND : (value.contains("m") ? TimeUnit.MINUTE : (value.contains("H") ? TimeUnit.HOUR : (value.contains("d") ? TimeUnit.DAY : (value.contains("M") ? TimeUnit.MONTH : TimeUnit.YEAR))));
        this.varFormat = false;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit value) {
        this.timeUnit = value;
    }

    public boolean isVarFormat() {
        return this.varFormat;
    }

    public void setVarFormat(boolean value) {
        this.varFormat = value;
    }

    @Override
    public void updateTickLabels() {
        ArrayList<ChartText> tls = new ArrayList<ChartText>();
        DateTimeFormatter format = DateTimeFormatter.ofPattern(this.timeFormat);
        double[] tvs = this.getTickValues();
        if (tvs != null) {
            for (double value : this.getTickValues()) {
                LocalDateTime date = JDateUtil.fromOADate((double)value);
                String lab = format.format(date);
                tls.add(new ChartText(lab));
            }
        }
        this.setTickLabels(tls);
    }

    @Override
    public void updateTickValues() {
        if (this.varFormat) {
            this.updateTimeTickValues_var();
        } else if (this.timeUnit != null) {
            this.updateTimeTickValues();
        }
    }

    private void updateTimeTickValues() {
        LocalDateTime sdate = JDateUtil.fromOADate((double)this.getMinValue());
        LocalDateTime edate = JDateUtil.fromOADate((double)this.getMaxValue());
        LocalDateTime ssdate = LocalDateTime.of(sdate.getYear(), sdate.getMonthValue(), sdate.getDayOfMonth(), sdate.getHour(), sdate.getMinute(), sdate.getSecond());
        ArrayList<LocalDateTime> dates = new ArrayList<LocalDateTime>();
        switch (this.timeUnit) {
            case YEAR: {
                sdate = LocalDateTime.of(sdate.getYear(), 1, 1, 0, 0, 0);
                if (!sdate.isBefore(ssdate)) {
                    dates.add(sdate);
                }
                while (!sdate.isAfter(edate)) {
                    sdate = sdate.withYear(sdate.getYear() + 1);
                    dates.add(sdate);
                }
                break;
            }
            case MONTH: {
                sdate = LocalDateTime.of(sdate.getYear(), sdate.getMonthValue(), 1, 0, 0, 0);
                if (!sdate.isBefore(ssdate)) {
                    dates.add(sdate);
                }
                while (!sdate.isAfter(edate)) {
                    if ((sdate = sdate.plusMonths(1L)).isBefore(ssdate)) continue;
                    dates.add(sdate);
                }
                break;
            }
            case DAY: {
                sdate = LocalDateTime.of(sdate.getYear(), sdate.getMonthValue(), sdate.getDayOfMonth(), 0, 0, 0);
                if (!sdate.isBefore(ssdate)) {
                    dates.add(sdate);
                }
                while (!sdate.isAfter(edate)) {
                    if (!(sdate = sdate.plusDays(1L)).isBefore(edate)) continue;
                    dates.add(sdate);
                }
                break;
            }
            case HOUR: {
                sdate = LocalDateTime.of(sdate.getYear(), sdate.getMonthValue(), sdate.getDayOfMonth(), sdate.getHour(), 0, 0);
                if (!sdate.isBefore(ssdate)) {
                    dates.add(sdate);
                }
                while (!sdate.isAfter(edate)) {
                    if (!(sdate = sdate.plusHours(1L)).isBefore(edate)) continue;
                    dates.add(sdate);
                }
                break;
            }
            case MINUTE: {
                sdate = ssdate.withSecond(0);
                if (!sdate.isBefore(ssdate)) {
                    dates.add(sdate);
                }
                while (!sdate.isAfter(edate)) {
                    if (!(sdate = sdate.plusMinutes(1L)).isBefore(edate)) continue;
                    dates.add(sdate);
                }
                break;
            }
            case SECOND: {
                if (!sdate.isBefore(ssdate)) {
                    dates.add(sdate);
                }
                while (!sdate.isAfter(edate)) {
                    if (!(sdate = sdate.plusSeconds(1L)).isBefore(edate)) continue;
                    dates.add(sdate);
                }
                break;
            }
        }
        double[] tvs = new double[dates.size()];
        for (int i = 0; i < dates.size(); ++i) {
            tvs[i] = JDateUtil.toOADate((LocalDateTime)((LocalDateTime)dates.get(i)));
        }
        this.setTickValues(tvs);
    }

    private void updateTimeTickValues_var() {
        LocalDateTime sdate = JDateUtil.fromOADate((double)this.getMinValue());
        LocalDateTime edate = JDateUtil.fromOADate((double)this.getMaxValue());
        LocalDateTime ssdate = sdate;
        ArrayList<LocalDateTime> dates = new ArrayList<LocalDateTime>();
        sdate = ssdate.plusYears(5L);
        if (sdate.isBefore(edate)) {
            this.timeFormat = "yyyy";
            this.timeUnit = TimeUnit.YEAR;
            sdate = ssdate.withMonth(1);
            sdate = ssdate.withDayOfMonth(1);
            sdate = ssdate.withHour(0);
            sdate = ssdate.withMinute(0);
            sdate = ssdate.withSecond(0);
            if (!sdate.isBefore(ssdate)) {
                dates.add(sdate);
            }
            while (!sdate.isAfter(edate)) {
                if (!(sdate = sdate.plusYears(1L)).isBefore(edate)) continue;
                dates.add(sdate);
            }
        } else {
            sdate = ssdate.plusMonths(5L);
            if (sdate.isBefore(edate)) {
                this.timeFormat = "M";
                this.timeUnit = TimeUnit.MONTH;
                sdate = ssdate.withDayOfMonth(1);
                sdate = ssdate.withHour(0);
                sdate = ssdate.withMinute(0);
                sdate = ssdate.withSecond(0);
                if (!sdate.isBefore(ssdate)) {
                    dates.add(sdate);
                }
                while (!sdate.isAfter(edate)) {
                    if (!(sdate = sdate.plusMonths(1L)).isBefore(edate)) continue;
                    dates.add(sdate);
                }
            } else {
                sdate = ssdate.plusDays(5L);
                if (sdate.isBefore(edate)) {
                    this.timeFormat = "d";
                    this.timeUnit = TimeUnit.DAY;
                    sdate = ssdate.withHour(0);
                    sdate = ssdate.withMinute(0);
                    sdate = ssdate.withSecond(0);
                    if (!sdate.isBefore(ssdate)) {
                        dates.add(sdate);
                    }
                    while (!sdate.isAfter(edate)) {
                        if (!(sdate = sdate.plusDays(1L)).isBefore(edate)) continue;
                        dates.add(sdate);
                    }
                } else {
                    sdate = ssdate.plusHours(5L);
                    if (sdate.isBefore(edate)) {
                        this.timeFormat = "H";
                        this.timeUnit = TimeUnit.HOUR;
                        sdate = ssdate.withMinute(0);
                        sdate = ssdate.withSecond(0);
                        if (!sdate.isBefore(ssdate)) {
                            dates.add(sdate);
                        }
                        while (!sdate.isAfter(edate)) {
                            if (!(sdate = sdate.plusHours(1L)).isBefore(edate)) continue;
                            dates.add(sdate);
                        }
                    } else {
                        sdate = ssdate.plusMinutes(5L);
                        if (sdate.isBefore(edate)) {
                            this.timeFormat = "HH:mm";
                            this.timeUnit = TimeUnit.MINUTE;
                            sdate = ssdate.withSecond(0);
                            if (!sdate.isBefore(ssdate)) {
                                dates.add(sdate);
                            }
                            while (!sdate.isAfter(edate)) {
                                if (!(sdate = sdate.plusMinutes(1L)).isBefore(edate)) continue;
                                dates.add(sdate);
                            }
                        } else {
                            this.timeFormat = "HH:mm:ss";
                            this.timeUnit = TimeUnit.SECOND;
                            if (!sdate.isBefore(ssdate)) {
                                dates.add(sdate);
                            }
                            while (!sdate.isAfter(edate)) {
                                if (!(sdate = sdate.plusSeconds(1L)).isBefore(edate)) continue;
                                dates.add(sdate);
                            }
                        }
                    }
                }
            }
        }
        double[] tvs = new double[dates.size()];
        for (int i = 0; i < dates.size(); ++i) {
            tvs[i] = JDateUtil.toOADate((LocalDateTime)((LocalDateTime)dates.get(i)));
        }
        this.setTickValues(tvs);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (TimeAxis)super.clone();
    }
}

